/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.util.ArrayList;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.java.DNFilter;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.Node;

public class ListFilter
extends DNFilter {
    static final long serialVersionUID = -1968720333965672314L;
    private String[] children;
    private boolean ignoreNull;
    private boolean emptyName;
    private boolean hasBounds;

    public ListFilter(String pattern, String[] children, boolean ignoreNull, boolean emptyName, boolean hasBounds) {
        super(pattern);
        this.children = children;
        this.ignoreNull = ignoreNull;
        this.emptyName = emptyName;
        this.hasBounds = hasBounds;
    }

    public AbstractVariable[] getVariables(VariablesProducer variable) {
        AbstractVariable[] vs;
        int k = this.children.length;
        JavaVariable v = (JavaVariable)variable;
        int i = 0;
        while (i < k) {
            if ((v = (JavaVariable)v.getVariable(this.children[i])) == null) {
                return variable.getVariables();
            }
            ++i;
        }
        if (this.hasBounds) {
            JavaVariable var = (JavaVariable)variable;
            vs = v.filterVariables(null, var.getStartIndex(), var.getLength());
        } else {
            vs = v.getVariablesFilter().getVariables(v);
        }
        if (this.ignoreNull) {
            k = vs.length;
            ArrayList<AbstractVariable> l = new ArrayList<AbstractVariable>(k);
            i = 0;
            while (i < k) {
                if (vs[i].getAsText() != null && !vs[i].getAsText().equals("null")) {
                    l.add(vs[i]);
                }
                ++i;
            }
            vs = new AbstractVariable[l.size()];
            l.toArray(vs);
        }
        return vs;
    }

    public Node.Property[] getProperties(AbstractVariable v) {
        if (!this.hasBounds) {
            return super.getProperties(v);
        }
        try {
            return new Node.Property[]{Utils.createProperty(v, Integer.TYPE, "startIndex", JavaDebugger.getString("PROP_base_index"), JavaDebugger.getString("HINT_base_index"), "getStartIndex", "setStartIndex"), Utils.createProperty(v, Integer.TYPE, "length", JavaDebugger.getString("PROP_displayed_length"), JavaDebugger.getString("HINT_displayed_length"), "getLength", "setLength")};
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getProperties(v);
        }
    }

    public boolean elementsSorted() {
        return true;
    }
}

