/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.support.util.AbstractHistory;

public final class PackageClassHistory
extends AbstractHistory
implements Serializable {
    private static final long serialVersionUID = -5570992805687742591L;
    private final int maxSize;
    private final int maxClassListSize;
    private final ArrayList entries;
    private transient ArrayList selectedClasses;
    private transient String pkg;

    public PackageClassHistory(int maxSize, int maxClassListSize, String[] items) {
        this.maxSize = maxSize;
        this.maxClassListSize = maxClassListSize;
        this.entries = new ArrayList(maxSize);
        if (items != null) {
            int size = items.length / 2;
            if (size > maxSize) {
                size = maxSize;
            }
            int index = 0;
            int i = 0;
            while (i < size) {
                String pkg = items[index++];
                String cls = items[index++];
                this.entries.add(new PackageClassEntry(pkg, cls));
                ++i;
            }
        }
    }

    public void addItem(Object item) {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        if (!(item instanceof String)) {
            throw new IllegalArgumentException("Argument must be non-null String.");
        }
        String clsName = (String)item;
        int index = this.selectedClasses.indexOf(clsName);
        if (index == -1) {
            int size = this.getSize();
            if (size == this.maxClassListSize) {
                PackageClassEntry entry;
                Iterator i = ((AbstractList)this.entries).iterator();
                do {
                    entry = (PackageClassEntry)i.next();
                } while (!entry.pkg.equals(this.pkg));
                i.remove();
                this.selectedClasses.remove(0);
                this.entries.add(new PackageClassEntry(this.pkg, clsName));
                this.selectedClasses.add(clsName);
                this.fireShifted(entry.cls, clsName);
            } else {
                if (this.entries.size() == this.maxSize) {
                    PackageClassEntry entry;
                    Iterator i = ((AbstractList)this.entries).iterator();
                    do {
                        entry = (PackageClassEntry)i.next();
                    } while (entry.pkg.equals(this.pkg));
                    i.remove();
                }
                this.entries.add(new PackageClassEntry(this.pkg, clsName));
                this.selectedClasses.add(clsName);
                this.fireAdded(clsName);
            }
        } else if (index != this.getSize() - 1) {
            PackageClassEntry entry = null;
            Iterator i = ((AbstractList)this.entries).iterator();
            while (i.hasNext()) {
                entry = (PackageClassEntry)i.next();
                if (entry.pkg.equals(this.pkg) && entry.cls.equals(clsName)) break;
            }
            i.remove();
            this.entries.add(entry);
            this.selectedClasses.remove(index);
            this.selectedClasses.add(item);
            this.fireChanged();
        }
    }

    public List getItems() {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        return Collections.unmodifiableList(this.selectedClasses);
    }

    public String[] getItemsAsArray() {
        if (this.entries.isEmpty()) {
            return new String[0];
        }
        String[] array = new String[2 * this.entries.size()];
        int index = 0;
        Iterator i = ((AbstractList)this.entries).iterator();
        while (i.hasNext()) {
            PackageClassEntry entry = (PackageClassEntry)i.next();
            array[index++] = entry.pkg;
            array[index++] = (String)entry.cls;
        }
        return array;
    }

    public int getMaxSize() {
        return this.maxClassListSize;
    }

    public int getSize() {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        return this.selectedClasses.size();
    }

    public boolean isEmpty() {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not specified.");
        }
        return this.selectedClasses.isEmpty();
    }

    public void setPackage(String pkg) {
        if (pkg.equals(this.pkg)) {
            return;
        }
        this.pkg = pkg;
        if (this.selectedClasses == null) {
            this.selectedClasses = new ArrayList(this.maxClassListSize);
        } else {
            this.selectedClasses.clear();
        }
        Iterator i = ((AbstractList)this.entries).iterator();
        int freeSpace = this.maxClassListSize;
        while (i.hasNext() && freeSpace > 0) {
            PackageClassEntry entry = (PackageClassEntry)i.next();
            if (!entry.pkg.equals(pkg)) continue;
            this.selectedClasses.add(entry.cls);
            --freeSpace;
        }
        this.fireChanged();
    }

    private static class PackageClassEntry
    implements Serializable {
        private static final long serialVersionUID = -2690943240619717844L;
        String pkg;
        Object cls;

        public PackageClassEntry(String pkg, Object cls) {
            this.pkg = pkg;
            this.cls = cls;
        }

        public boolean equals(Object o) {
            if (o instanceof PackageClassEntry) {
                PackageClassEntry entry = (PackageClassEntry)o;
                return entry.pkg.equals(this.pkg) && entry.cls.equals(this.cls);
            }
            return false;
        }
    }
}

