/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaWatch;
import org.netbeans.modules.debugger.support.java.PrintActionPanel;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class PrintAction
extends CoreBreakpoint.Action {
    static final long serialVersionUID = -5177383273138374863L;
    public static final String BREAKPOINT_TEXT = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$PrintAction == null ? (class$org$netbeans$modules$debugger$support$java$PrintAction = PrintAction.class$("org.netbeans.modules.debugger.support.java.PrintAction")) : class$org$netbeans$modules$debugger$support$java$PrintAction)).getString("CTL_Default_print_text");
    public static final String BREAKPOINT_METHOD_TEXT = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$PrintAction == null ? (class$org$netbeans$modules$debugger$support$java$PrintAction = PrintAction.class$("org.netbeans.modules.debugger.support.java.PrintAction")) : class$org$netbeans$modules$debugger$support$java$PrintAction)).getString("CTL_Default_method_print_text");
    public static final String BREAKPOINT_EXCEPTION_TEXT = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$PrintAction == null ? (class$org$netbeans$modules$debugger$support$java$PrintAction = PrintAction.class$("org.netbeans.modules.debugger.support.java.PrintAction")) : class$org$netbeans$modules$debugger$support$java$PrintAction)).getString("CTL_Default_exception_print_text");
    public static final String RUN_TO_CURSOR_TEXT = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$PrintAction == null ? (class$org$netbeans$modules$debugger$support$java$PrintAction = PrintAction.class$("org.netbeans.modules.debugger.support.java.PrintAction")) : class$org$netbeans$modules$debugger$support$java$PrintAction)).getString("CTL_Default_run_to_cursor_print_text");
    public static final String PROP_PRINT_TEXT = "printText";
    protected String text;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$PrintAction;
    static /* synthetic */ Class class$java$lang$String;

    public PrintAction(String s) {
        this.text = s;
    }

    public Node.Property[] getProperties() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$PrintAction == null ? (class$org$netbeans$modules$debugger$support$java$PrintAction = PrintAction.class$("org.netbeans.modules.debugger.support.java.PrintAction")) : class$org$netbeans$modules$debugger$support$java$PrintAction));
        return new Node.Property[]{Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = PrintAction.class$("java.lang.String")) : class$java$lang$String, PROP_PRINT_TEXT, bundle.getString("PROP_print_text"), bundle.getString("HINT_print_text"), "getPrintText", "setPrintText")};
    }

    protected void perform(CoreBreakpoint.Event event, Line l) {
        if (this.text == null || this.text.trim().length() < 1) {
            return;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        StringBuffer sb = new StringBuffer();
        while ((j = this.text.indexOf(123, i)) >= 0) {
            String var;
            sb.append(this.text.substring(i, j));
            if (j + 1 < this.text.length() && this.text.charAt(j + 1) != '$') {
                k = this.text.indexOf(125, j + 1);
                var = k >= 0 ? this.text.substring(j + 1, k) : this.text.substring(j + 2);
                this.resolveTag(var, event, sb);
                if (k < 0) {
                    i = -1;
                    break;
                }
                i = k + 1;
                continue;
            }
            k = this.text.indexOf(125, j);
            var = k >= 0 ? this.text.substring(j + 2, k) : this.text.substring(j + 1);
            String val = this.getValue(var, event);
            sb.append(val).append(' ');
            if (k < 0) {
                i = -1;
                break;
            }
            i = k + 1;
        }
        sb.append(this.text.substring(i, this.text.length()));
        IOManager io = ((JavaDebugger)event.getDebugger()).getIOManager();
        String s = new String(sb);
        if (l != null) {
            io.println(s, 1, l);
        } else {
            io.println(s, 1);
        }
        StatusDisplayer.getDefault().setStatusText(s);
    }

    protected void perform(CoreBreakpoint.Event event) {
        JavaThread t;
        Line[] ls = event.getLines();
        Line l = null;
        if (ls != null && ls.length == 1) {
            l = ls[0];
        }
        if (l == null && (t = ((InfoProducer)((Object)event)).getThread()) != null) {
            l = t.getLine();
        }
        this.perform(event, l);
    }

    public JComponent getCustomizer() {
        return new PrintActionPanel(this);
    }

    public String getPrintText() {
        return this.text;
    }

    public void setPrintText(String s) {
        if (s == this.text || s != null && this.text != null && this.text.equals(s)) {
            return;
        }
        String old = this.text;
        this.text = s;
        this.firePropertyChange(PROP_PRINT_TEXT, old, s);
    }

    protected void resolveTag(String tag, CoreBreakpoint.Event event, StringBuffer sb) {
        if (tag.equals("threadName")) {
            JavaThread tt = ((InfoProducer)((Object)event)).getThread();
            if (tt == null) {
                sb.append('?');
            } else {
                try {
                    sb.append(tt.getName());
                }
                catch (Exception e) {
                    sb.append('?');
                }
            }
        } else if (tag.equals("className")) {
            CallStackFrame[] stack = ((InfoProducer)((Object)event)).getCallStack();
            if (stack == null || stack.length < 1) {
                sb.append('?');
            } else {
                try {
                    sb.append(stack[0].getClassName());
                }
                catch (Exception e) {
                    sb.append('?');
                }
            }
        } else if (tag.equals("lineNumber")) {
            CallStackFrame[] stack = ((InfoProducer)((Object)event)).getCallStack();
            if (stack == null || stack.length < 1 || stack[0].getLine() == null) {
                sb.append('?');
            } else {
                try {
                    sb.append(stack[0].getLineNumber());
                }
                catch (Exception e) {
                    sb.append('?');
                }
            }
        } else if (tag.equals("methodName")) {
            CallStackFrame[] stack = ((InfoProducer)((Object)event)).getCallStack();
            if (stack == null || stack.length < 1) {
                sb.append('?');
            } else {
                try {
                    sb.append(stack[0].getMethodName());
                }
                catch (Exception e) {
                    sb.append('?');
                }
            }
        } else if (tag.equals("variableValue")) {
            JavaVariable variable = ((InfoProducer)((Object)event)).getVariable();
            if (variable == null) {
                sb.append('?');
            } else {
                String s = variable.toStringValue();
                if (s == null) {
                    sb.append("?");
                } else {
                    sb.append(s);
                }
            }
        } else if (tag.equals("variableType")) {
            JavaVariable variable = ((InfoProducer)((Object)event)).getVariable();
            if (variable == null) {
                sb.append('?');
            } else {
                String s = variable.getInnerType();
                if (s == null) {
                    sb.append('?');
                } else {
                    sb.append(s);
                }
            }
        } else {
            sb.append('?');
        }
    }

    protected String getValue(String variable, CoreBreakpoint.Event event) {
        JavaWatch w = (JavaWatch)event.getDebugger().createWatch(variable, true);
        w.refreshValue(((InfoProducer)((Object)event)).getThread());
        if (w == null) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$PrintAction == null ? (class$org$netbeans$modules$debugger$support$java$PrintAction = PrintAction.class$("org.netbeans.modules.debugger.support.java.PrintAction")) : class$org$netbeans$modules$debugger$support$java$PrintAction)).getString("CTL_Not_in_scope");
        }
        String res = w.getAsText();
        w.remove();
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

