/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.delegator.DelegatingWatch;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaWatch;
import org.netbeans.modules.debugger.support.util.RequestProcessor;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private String toolTipText = null;
    private StyledDocument doc;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public String getShortDescription() {
        this.toolTipText = null;
        if (!(Register.getCurrentDebugger() instanceof JavaDebugger)) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        Line line = lp.getLine();
        DataObject dob = line.getDataObject();
        EditorCookie ec = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = ToolTipAnnotation.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (ec != null) {
            try {
                this.doc = ec.openDocument();
                RequestProcessor.postRequest(this);
                this.doc.render(this);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.toolTipText;
    }

    public void run() {
        AbstractWatch w1;
        AbstractWatch watch;
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        JEditorPane ep = Utils.getCurrentEditor();
        if (lp == null || ep == null) {
            return;
        }
        String text = Utils.getIdentifier(this.doc, ep, NbDocument.findLineOffset((StyledDocument)this.doc, (int)lp.getLine().getLineNumber()) + lp.getColumn());
        if (text == null) {
            return;
        }
        CoreDebugger debugger = Register.getCoreDebugger();
        AbstractWatch w = watch = (AbstractWatch)debugger.createWatch(text, true);
        if (watch instanceof DelegatingWatch && (w1 = (AbstractWatch)((DelegatingWatch)watch).getInnerWatch()) != null) {
            w = w1;
        }
        String old = this.toolTipText;
        this.toolTipText = null;
        String errorMessage = w.getErrorMessage();
        if (w != null && errorMessage == null) {
            if (w instanceof JavaWatch) {
                this.toolTipText = ((JavaWatch)w).toStringValue();
            }
            if (this.toolTipText == null) {
                this.toolTipText = w.getAsText();
            }
            if (this.toolTipText != null) {
                this.toolTipText = text + " = " + this.toolTipText;
            }
        }
        watch.remove();
        this.firePropertyChange("shortDescription", old, this.toolTipText);
    }

    public String getAnnotationType() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

