/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.nodes.LocationNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CallStackLineNode
extends LocationNode {
    static final long serialVersionUID = -490111283333957792L;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode;

    public CallStackLineNode(CallStackFrame stackFrame, CallStackProducer producer, int index, boolean showSubNodes) {
        super(stackFrame, producer, index, showSubNodes);
    }

    protected void finalize() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerCallStackLineNode");
    }

    protected void createProperties() {
        PropertySupport.Reflection prop;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set props = sheet.get("properties");
        props.setValue("helpID", "NetbeansDebuggerCallStackPropertiesSheet");
        props.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "className", CallStackLineNode.getLocalizedString("PROP_call_stack_class_name"), CallStackLineNode.getLocalizedString("HINT_call_stack_class_name"), "getCallStackFrameClassName", null));
        props.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "methodName", CallStackLineNode.getLocalizedString("PROP_call_stack_method_name"), CallStackLineNode.getLocalizedString("HINT_call_stack_method_name"), "getCallStackFrameMethodName", null));
        props.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "lineNumber", CallStackLineNode.getLocalizedString("PROP_call_stack_line_number"), CallStackLineNode.getLocalizedString("HINT_call_stack_line_number"), "getCallStackFrameLineNumber", null));
        try {
            prop = new PropertySupport.Reflection((Object)this, class$java$lang$String == null ? (class$java$lang$String = CallStackLineNode.class$("java.lang.String")) : class$java$lang$String, "getLocation", "setLocation");
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        prop.setName("location");
        prop.setDisplayName(CallStackLineNode.getLocalizedString("PROP_location"));
        prop.setShortDescription(CallStackLineNode.getLocalizedString("HINT_location"));
        try {
            prop.setPropertyEditorClass(Class.forName("org.netbeans.modules.debugger.support.util.LinkEditor"));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        props.put((Node.Property)prop);
        this.setSheet(sheet);
    }

    protected void updateName() {
        CallStackFrame f = (CallStackFrame)this.location;
        String s = f.getClassName();
        int i = s.lastIndexOf(46);
        if (i > 0) {
            s = s.substring(i + 1);
        }
        s = s + "." + f.getMethodName();
        int j = f.getLineNumber();
        if (this.showSubNodes && j > 0) {
            s = s + ":" + j;
        }
        this.setDisplayName(s);
        this.setName(s);
    }

    public String getCallStackFrameClassName() {
        return ((CallStackFrame)this.location).getClassName();
    }

    public String getCallStackFrameMethodName() {
        return ((CallStackFrame)this.location).getMethodName();
    }

    public String getCallStackFrameLineNumber() {
        int i = ((CallStackFrame)this.location).getLineNumber();
        if (i < 0) {
            return "";
        }
        return "" + i;
    }

    public String getLocation() {
        try {
            String j;
            String p;
            int i;
            String s = ((CallStackFrame)this.location).getSourceName();
            if (s.endsWith(".java")) {
                s = s.substring(0, s.length() - 5);
            }
            if ((i = s.lastIndexOf(46)) < 0 && (i = (p = ((CallStackFrame)this.location).getClassName()).lastIndexOf(46)) > 0) {
                s = p.substring(0, i + 1) + s;
            }
            if ((j = this.getCallStackFrameLineNumber()).length() < 1) {
                return s + ".java";
            }
            return s + ".java:" + j;
        }
        catch (DebuggerException debuggerException) {
            return CallStackLineNode.getLocalizedString("MSG_Not_available");
        }
    }

    public void setLocation(String s) {
    }

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode = CallStackLineNode.class$("org.netbeans.modules.debugger.support.java.nodes.CallStackLineNode")) : class$org$netbeans$modules$debugger$support$java$nodes$CallStackLineNode), (String)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

