/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.LoadedClassesProducer;
import org.netbeans.modules.debugger.support.java.nodes.PackageContent;
import org.netbeans.modules.debugger.support.java.nodes.PackageNode;
import org.netbeans.modules.debugger.support.util.RequestProcessor;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ClassesRootNode
extends PackageNode
implements Validator.Object {
    static final long serialVersionUID = -5432332119936122231L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/classesView/Classes";
    private AbstractDebugger debugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode;

    public ClassesRootNode() {
        this(false);
    }

    public ClassesRootNode(boolean isInTree) {
        super(new PackageContent(""));
        String name = null;
        if (isInTree) {
            name = NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode = ClassesRootNode.class$("org.netbeans.modules.debugger.support.java.nodes.ClassesRootNode")) : class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode), (String)"PROP_classes_column_name");
            this.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode = ClassesRootNode.class$("org.netbeans.modules.debugger.support.java.nodes.ClassesRootNode")) : class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode), (String)"HINT_classes_column_name"));
        } else {
            name = NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode = ClassesRootNode.class$("org.netbeans.modules.debugger.support.java.nodes.ClassesRootNode")) : class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode), (String)"CTL_Classes_root");
        }
        this.setDisplayName(name);
        this.setName("ClassesRootNode");
    }

    protected void init() {
        this.debugger = Register.getCoreDebugger();
        this.debugger.addPropertyChangeListener(new StateListener(this, this.debugger));
        this.setIconBase(ICON_BASE);
        this.changeChildren();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerClassesRootNode");
    }

    public Node.Handle getHandle() {
        return new ClassesHandle();
    }

    void changeChildren() {
        List list = null;
        AbstractDebugger debugger = Register.getCurrentDebugger();
        list = debugger == null ? new ArrayList() : (debugger instanceof LoadedClassesProducer ? ((LoadedClassesProducer)((Object)debugger)).getLoadedClasses() : new ArrayList());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.content.add((JavaClass)iter.next());
        }
        this.content.reorganize();
        ((PackageNode.PackageChildren)this.getChildren()).setContent(this.content);
    }

    public void validate() {
        int state = this.debugger.getState();
        if (state == 4 || state == 1) {
            try {
                this.changeChildren();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canRemove() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClassesHandle
    implements Node.Handle {
        static final long serialVersionUID = -3418262400286559650L;

        private ClassesHandle() {
        }

        public Node getNode() {
            return new ClassesRootNode();
        }
    }

    private static class RefreshThread
    extends Thread {
        private boolean finished = false;
        private WeakReference node;
        private Debugger debugger;

        public RefreshThread(String name, WeakReference node, Debugger debugger) {
            super(name);
            this.node = node;
            this.debugger = debugger;
        }

        public void finish() {
            this.finished = true;
        }

        public void run() {
            while (!this.finished) {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e) {
                    this.finished = true;
                }
                final Object clsNode = this.node.get();
                if (clsNode == null) {
                    this.finish();
                    break;
                }
                RequestProcessor.postRequest(new Runnable(){

                    public void run() {
                        if (debugger.getState() != 1) {
                            try {
                                ((ClassesRootNode)clsNode).changeChildren();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    private static class StateListener
    implements PropertyChangeListener {
        private RefreshThread thread = null;
        private WeakReference node;
        private AbstractDebugger debugger;

        public StateListener(ClassesRootNode clsNode, AbstractDebugger debugger) {
            this.node = new WeakReference<ClassesRootNode>(clsNode);
            this.debugger = debugger;
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object clsNode = this.node.get();
            if (clsNode == null) {
                this.debugger.removePropertyChangeListener(this);
                if (this.thread != null) {
                    this.thread.finish();
                }
                return;
            }
            if (!e.getPropertyName().equals("state")) {
                return;
            }
            switch (this.debugger.getState()) {
                case 1: {
                    StateListener stateListener = this;
                    synchronized (stateListener) {
                        if (this.thread != null) {
                            this.thread.finish();
                            this.thread = null;
                        }
                        ((ClassesRootNode)clsNode).changeChildren();
                        break;
                    }
                }
                case 3: {
                    StateListener stateListener = this;
                    synchronized (stateListener) {
                        if (this.thread != null) {
                            this.thread.finish();
                        }
                        this.thread = new RefreshThread("Debugger Classes Refresher", this.node, this.debugger);
                        this.thread.start();
                        break;
                    }
                }
            }
        }
    }
}

