/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.actions.SuspendCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.MonitorInfoProducer;
import org.netbeans.modules.debugger.support.nodes.ThreadNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.ErrorManager;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class JavaThreadNode
extends AbstractNode
implements SuspendCookie,
SwitchOnCookie,
GoToSourceCookie {
    static final long serialVersionUID = 2202990736781010124L;
    public static final String PROP_THREAD_NAME = "threadName";
    public static final String PROP_THREAD_STATE = "threadState";
    public static final String PROP_THREAD_CLASS = "threadClass";
    public static final String PROP_THREAD_METHOD = "threadMethod";
    public static final String PROP_THREAD_LINE = "threadLine";
    public static final String PROP_THREAD_STACK_DEPTH = "threadStackDepth";
    public static final String PROP_THREAD_FRAME_INDEX = "threadFrameIndex";
    public static final String PROP_THREAD_SUSPENDED = "threadSuspended";
    public static final int STATE_MAIN = 1;
    public static final int STATE_STOPPED = 2;
    protected static String ICON_CURRENT = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    protected static String ICON_SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    protected static String ICON_RUNNING = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    private static SystemAction[] staticActions;
    private CoreDebugger coreDebugger;
    private AbstractDebugger debugger;
    private final JavaThread thread;
    private ThreadListener threadListener;
    private int state = 4;
    private boolean oldSuspended = false;
    private String dispNamePrefix;
    private boolean showSubNodes;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$JavaThreadNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchOnAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SuspendResumeAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToSourceAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$JavaThreadNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$JavaThreadNode = JavaThreadNode.class$("org.netbeans.modules.debugger.support.java.nodes.JavaThreadNode")) : class$org$netbeans$modules$debugger$support$java$nodes$JavaThreadNode), (String)s);
    }

    public JavaThreadNode(JavaThread thread, AbstractDebugger debugger) {
        this(thread, debugger, null, true);
    }

    public JavaThreadNode(JavaThread thread, AbstractDebugger debugger, String dispNamePrefix) {
        this(thread, debugger, dispNamePrefix, true);
    }

    public JavaThreadNode(JavaThread thread, AbstractDebugger debugger, boolean showSubNodes) {
        this(thread, debugger, null, showSubNodes);
    }

    private JavaThreadNode(JavaThread thread, AbstractDebugger debugger, String dispNamePrefix, boolean showSubNodes) {
        super((Children)(showSubNodes ? new ThreadChildren() : Children.LEAF));
        this.thread = thread;
        this.showSubNodes = showSubNodes;
        this.debugger = debugger;
        this.dispNamePrefix = dispNamePrefix;
        this.coreDebugger = Register.getCoreDebugger();
        this.setName();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.threadListener = new ThreadListener(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadNode");
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set props = sheet.get("properties");
        props.setValue("helpID", "NetbeansDebuggerThreadsPropertiesSheet");
        props.put(Utils.createProperty(this.thread, class$java$lang$String == null ? (class$java$lang$String = JavaThreadNode.class$("java.lang.String")) : class$java$lang$String, PROP_THREAD_NAME, JavaThreadNode.getLocalizedString("PROP_thread_name"), JavaThreadNode.getLocalizedString("HINT_thread_name"), "getName", null));
        props.put(Utils.createProperty(this.thread, class$java$lang$String == null ? (class$java$lang$String = JavaThreadNode.class$("java.lang.String")) : class$java$lang$String, PROP_THREAD_STATE, JavaThreadNode.getLocalizedString("PROP_thread_state"), JavaThreadNode.getLocalizedString("HINT_thread_state"), "getState", null));
        props.put(Utils.createProperty(this.thread, class$java$lang$String == null ? (class$java$lang$String = JavaThreadNode.class$("java.lang.String")) : class$java$lang$String, PROP_THREAD_CLASS, JavaThreadNode.getLocalizedString("PROP_thread_class"), JavaThreadNode.getLocalizedString("HINT_thread_class"), "getClassName", null));
        props.put(Utils.createProperty(this.thread, class$java$lang$String == null ? (class$java$lang$String = JavaThreadNode.class$("java.lang.String")) : class$java$lang$String, PROP_THREAD_METHOD, JavaThreadNode.getLocalizedString("PROP_thread_method"), JavaThreadNode.getLocalizedString("HINT_thread_method"), "getMethod", null));
        props.put(Utils.createProperty(this.thread, Integer.TYPE, PROP_THREAD_LINE, JavaThreadNode.getLocalizedString("PROP_thread_line"), JavaThreadNode.getLocalizedString("HINT_thread_line"), "getLineNumber", null));
        props.put(Utils.createProperty(this.thread, Integer.TYPE, PROP_THREAD_STACK_DEPTH, JavaThreadNode.getLocalizedString("PROP_thread_stack_depth"), JavaThreadNode.getLocalizedString("HINT_thread_stack_depth"), "getStackDepth", null));
        props.put(Utils.createProperty(this, Boolean.TYPE, PROP_THREAD_SUSPENDED, JavaThreadNode.getLocalizedString("PROP_thread_suspended"), JavaThreadNode.getLocalizedString("HINT_thread_suspended"), "isSuspended", "setSuspended"));
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = JavaThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SuspendResumeAction == null ? (class$org$netbeans$modules$debugger$support$actions$SuspendResumeAction = JavaThreadNode.class$("org.netbeans.modules.debugger.support.actions.SuspendResumeAction")) : class$org$netbeans$modules$debugger$support$actions$SuspendResumeAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = JavaThreadNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JavaThreadNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaThreadNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = JavaThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction));
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.threadListener != null) {
            this.coreDebugger.removePropertyChangeListener(this.threadListener);
            this.thread.removePropertyChangeListener(this.threadListener);
        }
    }

    public boolean canSetCurrent() {
        return !this.thread.isCurrent() && this.isSuspended();
    }

    public void setCurrent() {
        this.coreDebugger.setCurrentDebugger(this.debugger);
        this.thread.setCurrent(true);
    }

    public void setSuspended(boolean b) {
        try {
            this.thread.setSuspended(b);
            this.thread.refreshStack();
            if (this.getChildren() instanceof ThreadChildren) {
                ((ThreadChildren)this.getChildren()).refreshAll();
            }
        }
        catch (DebuggerException e) {
            ErrorManager.getDefault().notify(((InvocationTargetException)((Object)e)).getTargetException());
        }
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void goToSource() {
        Line l = this.thread.getLine();
        if (l != null) {
            l.show(2);
        }
    }

    public boolean canGoToSource() {
        Line l = this.thread.getLine();
        return l != null;
    }

    void refreshIcon() {
        if ((this.state & 1) != 0) {
            this.setIconBase(ICON_CURRENT);
        } else if ((this.state & 2) != 0) {
            this.setIconBase(ICON_SUSPENDED);
        } else {
            this.setIconBase(ICON_RUNNING);
        }
    }

    void changeProperties() {
        this.setName();
        this.firePropertyChange(null, null, null);
    }

    void setName() {
        int newS = 0;
        if (this.thread.isCurrent() && this.coreDebugger.getCurrentDebugger() == this.debugger) {
            newS = 1;
        }
        try {
            if (this.thread.isSuspended()) {
                newS |= 2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.state != newS) {
            this.state = newS;
            this.refreshIcon();
        }
        String s = this.thread.getName();
        if (this.showSubNodes) {
            s = s + " (" + this.thread.getState() + ")";
        }
        if (this.dispNamePrefix != null) {
            s = this.dispNamePrefix.concat(" ").concat(s);
        }
        this.setDisplayName(s);
        this.setName(s);
    }

    JavaThread getDebuggerThread() {
        return this.thread;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ThreadListener
    implements PropertyChangeListener {
        private WeakReference node;
        private CoreDebugger coreDebugger;
        private JavaThread thread;

        ThreadListener(JavaThreadNode n) {
            this.node = new WeakReference<JavaThreadNode>(n);
            this.coreDebugger = n.coreDebugger;
            this.thread = n.thread;
            this.thread.addPropertyChangeListener(this);
            this.coreDebugger.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            JavaThreadNode tn = (JavaThreadNode)this.node.get();
            if (tn == null) {
                this.coreDebugger.removePropertyChangeListener(this);
                this.thread.removePropertyChangeListener(this);
                return;
            }
            if (e.getSource() == this.coreDebugger && e.getPropertyName() != "currentDebugger") {
                return;
            }
            tn.changeProperties();
            String name = e.getPropertyName();
            if (name != null && name.equals("monitors") && tn.getChildren() instanceof ThreadChildren) {
                ((ThreadChildren)tn.getChildren()).refreshAll();
            }
        }
    }

    private static final class ThreadChildren
    extends Children.Keys {
        private boolean initialized = false;

        private ThreadChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            this.setRoots();
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            JavaThread thread = ((JavaThreadNode)this.getNode()).thread;
            Node node = NodesRegistry.getNode(key, new Object[]{thread, ((JavaThreadNode)this.getNode()).debugger});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        private void setRoots() {
            JavaThread thread = ((JavaThreadNode)this.getNode()).thread;
            LinkedList<String> l = new LinkedList<String>();
            if (thread instanceof VariablesProducer) {
                l.add("localsNode");
            }
            if (thread instanceof CallStackProducer) {
                l.add("callStackNode");
            }
            if (thread instanceof MonitorInfoProducer) {
                if (((MonitorInfoProducer)((Object)thread)).contendsMonitor()) {
                    l.add("contendedMonitorNode");
                }
                if (((MonitorInfoProducer)((Object)thread)).ownsMonitors()) {
                    l.add("ownedMonitorsNode");
                }
            }
            this.setKeys(l);
        }

        void refreshAll() {
            if (!this.initialized) {
                return;
            }
            this.setRoots();
            Node[] ns = this.getNodes();
            int k = ns.length;
            int i = 0;
            while (i < k) {
                if (ns[i] instanceof ThreadNode.Refreshable) {
                    ((ThreadNode.Refreshable)ns[i]).refresh();
                }
                ++i;
            }
        }
    }
}

