/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.actions.CreateVariableCookie;
import org.netbeans.modules.debugger.support.actions.DisplayAsCookie;
import org.netbeans.modules.debugger.support.actions.GetVariableCookie;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaVariablesFilter;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class JavaVariableNode
extends AbstractNode
implements GetVariableCookie,
CreateVariableCookie,
DisplayAsCookie {
    static final long serialVersionUID = -4167730413290269518L;
    protected static String ICON_BASE = "org/netbeans/modules/debugger/resources/watchesView/Field";
    protected static String ICON_STATIC_VARIABLE = "org/netbeans/modules/debugger/resources/watchesView/StaticField";
    protected static String ICON_FIXED_VARIABLE = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch";
    protected static String ICON_LOCAL_VARIABLE = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    public static final String PROP_MODIFIERS = "modifiers";
    public static final int TYPE_VARIABLE = 0;
    public static final int TYPE_LOCAL_VARIABLE = 1;
    public static final int TYPE_FIXED_VARIABLE = 2;
    private int type;
    protected JavaVariable variable = null;
    protected transient CoreDebugger debugger;
    private PropertyChangeListener pcl;
    protected boolean isArray;
    protected String variableType = "";
    private boolean showFullName;
    public static Comparator variablesComparator = new Comparator(){

        public int compare(Object o1, Object o2) throws ClassCastException {
            String n2;
            boolean firstStatic = false;
            if (o1 instanceof JavaVariable) {
                String m1 = ((JavaVariable)o1).getModifiers();
                firstStatic = m1.indexOf("static") >= 0;
            }
            boolean secondStatic = false;
            if (o2 instanceof JavaVariable) {
                String m2 = ((JavaVariable)o2).getModifiers();
                boolean bl = secondStatic = m2.indexOf("static") >= 0;
            }
            if (firstStatic != secondStatic) {
                return firstStatic ? 1 : -1;
            }
            String n1 = ((AbstractVariable)o1).getVariableName();
            if (n1 == null) {
                n1 = "";
            }
            if ((n2 = ((AbstractVariable)o2).getVariableName()) == null) {
                n2 = "";
            }
            return n1.compareToIgnoreCase(n2);
        }
    };
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateVariableAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisplayAsAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode;

    public JavaVariableNode(JavaVariable variable, int type) {
        this(variable, type, false);
    }

    public JavaVariableNode(JavaVariable variable, int type, boolean showFullName) {
        super((Children)(variable.isLeaf() ? Children.LEAF : new VariableContextChildren()));
        this.type = type;
        this.showFullName = showFullName;
        this.type = variable.isFixedVariable() ? 2 : type;
        this.variable = variable;
        this.isArray = variable.isArray();
        this.variableType = variable.getInnerType();
        this.init();
    }

    public JavaVariableNode(JavaVariable variable) {
        this(variable, 0, false);
    }

    protected void finalize() {
    }

    protected void init() {
        this.variable.addPropertyChangeListener(new VariableListener(this));
        this.setDisplayName(this.computeName());
        if (this.type == 2) {
            this.setIconBase(ICON_FIXED_VARIABLE);
        } else if (this.type == 1) {
            this.setIconBase(ICON_LOCAL_VARIABLE);
        } else if (!this.variable.isFixedVariable() && this.variable.getModifiers() != null && this.variable.getModifiers().indexOf("static") > -1) {
            this.setIconBase(ICON_STATIC_VARIABLE);
        } else {
            this.setIconBase(ICON_BASE);
        }
        this.debugger = Register.getCoreDebugger();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
    }

    private void readObject(ObjectInputStream obis) throws IOException, ClassNotFoundException, NotActiveException {
        obis.defaultReadObject();
        this.init();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariableNode");
    }

    protected void createProperties() {
        PropertySupport.Reflection prop;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.setValue("helpID", "NetbeansDebuggerLocalsPropertiesSheet");
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "variableName", JavaVariableNode.getLocalizedString("PROP_watch_name"), JavaVariableNode.getLocalizedString("HINT_watch_name"), "getVariableName", null));
        if (this.type != 2) {
            ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "type", JavaVariableNode.getLocalizedString("PROP_watch_type"), JavaVariableNode.getLocalizedString("HINT_watch_type"), "getVariableType", null));
        }
        try {
            prop = new PropertySupport.Reflection((Object)this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "getVariableInnerType", "setVariableInnerType");
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        prop.setName("type");
        prop.setDisplayName(JavaVariableNode.getLocalizedString("PROP_watch_inner_type"));
        prop.setShortDescription(JavaVariableNode.getLocalizedString("HINT_watch_inner_type"));
        try {
            prop.setPropertyEditorClass(Class.forName("org.netbeans.modules.debugger.support.util.LinkEditor"));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        ps.put((Node.Property)prop);
        if (this.type != 2) {
            ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, PROP_MODIFIERS, JavaVariableNode.getLocalizedString("PROP_watch_modifiers"), JavaVariableNode.getLocalizedString("HINT_watch_modifiers"), "getVariableModifiers", null));
        }
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaVariableNode.class$("java.lang.String")) : class$java$lang$String, "asText", JavaVariableNode.getLocalizedString("PROP_watch_value"), JavaVariableNode.getLocalizedString("HINT_watch_value"), "getVariableAsText", this.type == 2 ? null : "setVariableAsText"));
        VariablesFilter filter = this.variable.getVariablesFilter();
        Node.Property[] properties = filter.getProperties(this.variable);
        if (properties != null) {
            int x = 0;
            while (x < properties.length) {
                ps.put(properties[x]);
                ++x;
            }
        }
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        int i = 0;
        int k = this.getDisplayAsActions().length > 0 ? 6 : 4;
        SystemAction[] sa = new SystemAction[k];
        if (this.variable.isFixedVariable()) {
            sa[i++] = SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JavaVariableNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction));
        } else {
            sa[i++] = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaVariableNode.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction));
        }
        sa[i++] = null;
        if (this.getDisplayAsActions().length > 0) {
            sa[i++] = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisplayAsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisplayAsAction = JavaVariableNode.class$("org.netbeans.modules.debugger.support.actions.DisplayAsAction")) : class$org$netbeans$modules$debugger$support$actions$DisplayAsAction));
            sa[i++] = null;
        }
        sa[i++] = SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JavaVariableNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction));
        sa[i++] = SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaVariableNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        return sa;
    }

    public boolean canDestroy() {
        return this.variable.isFixedVariable();
    }

    public String getName() {
        return this.variable.getAsText();
    }

    public void setName(String value) {
        try {
            this.variable.setAsText(value);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public void destroy() throws IOException {
        if (this.variable == null) {
            super.destroy();
            return;
        }
        this.variable.removePropertyChangeListener(this.pcl);
        if (this.variable instanceof AbstractWatch) {
            ((AbstractWatch)((Object)this.variable)).remove();
        }
        this.variable = null;
        if (this.getChildren() == Children.LEAF) {
            super.destroy();
            return;
        }
        VariableContextChildren myChildren = (VariableContextChildren)this.getChildren();
        if (!myChildren.initialized) {
            super.destroy();
            return;
        }
        Node[] n = myChildren.getNodes();
        int k = n.length;
        int i = 0;
        while (i < k) {
            ((JavaVariableNode)n[i]).destroy();
            ++i;
        }
        super.destroy();
    }

    public AbstractVariable getVariable() {
        return this.variable;
    }

    public SystemAction[] getDisplayAsActions() {
        VariablesFilter filter = this.variable.getVariablesFilter();
        return filter.getActions(this.variable);
    }

    public Object getSpecialVariable(String variableName) {
        return this.variable.getSpecialVariable(variableName);
    }

    public void setSpecialVariable(String variableName, Object variableValue) {
        this.variable.setSpecialVariable(variableName, variableValue);
    }

    public String getVariableName() {
        return this.variable != null ? this.variable.getVariableName() : "";
    }

    public String getVariableType() {
        return this.variable != null ? this.variable.getType() : "";
    }

    public String getVariableInnerType() {
        if (this.variable == null) {
            return "";
        }
        String n = this.variable.getInnerType();
        return n;
    }

    public void setVariableInnerType(String s) {
    }

    public String getVariableModifiers() {
        return this.variable != null ? this.variable.getModifiers() : "";
    }

    public String getVariableAsText() {
        String na = this.variable.getVariablesFilter().getDisplayName(this.variable);
        if (na != null) {
            return na;
        }
        return this.variable != null ? this.variable.getAsText() : "";
    }

    public void setVariableAsText(String value) {
        try {
            this.variable.setAsText(value);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode = JavaVariableNode.class$("org.netbeans.modules.debugger.support.java.nodes.JavaVariableNode")) : class$org$netbeans$modules$debugger$support$java$nodes$JavaVariableNode), (String)s);
    }

    public String computeName() {
        if (!this.showFullName) {
            return this.variable.getVariableName();
        }
        String na = this.variable.getVariablesFilter().getDisplayName(this.variable);
        return this.variable.getVariableName() + " = (" + this.variable.getInnerType() + ") " + na;
    }

    public void createVariable() {
        DebuggerSupport d = (DebuggerSupport)Register.getCoreDebugger();
        JavaVariable fixedVar = this.variable.createFixedVariable();
        if (fixedVar instanceof AbstractWatch) {
            d.addWatch((AbstractWatch)((Object)fixedVar));
        }
    }

    public boolean canCreateVariable() {
        return !this.variable.isFixedVariable();
    }

    void parameterChanged(PropertyChangeEvent e) {
        if (this.variable.getInnerType() != this.variableType) {
            this.isArray = !this.isArray;
            this.variableType = this.variable.getInnerType();
            this.createProperties();
        }
        String s = this.computeName();
        this.setDisplayName(s);
        this.changeChildren();
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    void changeChildren() {
        if (this.getChildren() == Children.LEAF) {
            Node n = this.getParentNode();
            if (n == null) {
                return;
            }
            JavaVariable v = (JavaVariable)this.getVariable();
            if (!v.isLeaf()) {
                LeafRefresher parentChildren = (LeafRefresher)n.getChildren();
                parentChildren.refreshMyKey(v);
            }
            return;
        }
        VariableContextChildren myChildren = (VariableContextChildren)this.getChildren();
        if (!myChildren.initialized) {
            return;
        }
        JavaVariablesFilter filter = (JavaVariablesFilter)this.variable.getVariablesFilter();
        Object[] fields = filter.getVariables(this.variable);
        if (!filter.elementsSorted(this.variable)) {
            Arrays.sort(fields, variablesComparator);
            int x = 0;
            while (x < fields.length) {
                if (fields[x].getVariableName().equals("super")) {
                    Object temp = fields[x];
                    int y = x + 1;
                    while (y < fields.length) {
                        fields[y - 1] = fields[y];
                        ++y;
                    }
                    fields[fields.length - 1] = temp;
                }
                ++x;
            }
        }
        myChildren.setMyKeys(fields);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VariableListener
    implements PropertyChangeListener {
        private WeakReference node;
        private AbstractVariable variable;

        VariableListener(JavaVariableNode n) {
            this.node = new WeakReference<JavaVariableNode>(n);
            this.variable = n.variable;
        }

        public void propertyChange(PropertyChangeEvent e) {
            JavaVariableNode csn = (JavaVariableNode)this.node.get();
            if (csn == null) {
                this.variable.removePropertyChangeListener(this);
                return;
            }
            csn.parameterChanged(e);
        }
    }

    private static final class VariableContextChildren
    extends Children.Keys
    implements LeafRefresher {
        private boolean initialized = false;

        private VariableContextChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            ((JavaVariableNode)this.getNode()).changeChildren();
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{DebuggerNode.createNode(key)};
        }

        private void setMyKeys(Object[] keys) {
            this.setKeys(keys);
        }

        public void refreshMyKey(Object key) {
            this.refreshKey(key);
        }
    }
}

