/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.java.nodes.JavaVariableNode;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class JavaVariablesRootNode
extends AbstractNode {
    static final long serialVersionUID = -5432455019958452231L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static String ICON_PENDING_VARIABLES = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode = JavaVariablesRootNode.class$("org.netbeans.modules.debugger.support.java.nodes.JavaVariablesRootNode")) : class$org$netbeans$modules$debugger$support$java$nodes$JavaVariablesRootNode), (String)s);
    }

    public JavaVariablesRootNode() {
        this(false);
    }

    public JavaVariablesRootNode(boolean isInTree) {
        super((Children)new VariablesRootChildren());
        String name = null;
        if (isInTree) {
            name = JavaVariablesRootNode.getLocalizedString("PROP_locals_column_name");
            this.setShortDescription(JavaVariablesRootNode.getLocalizedString("HINT_locals_column_name"));
        } else {
            name = JavaVariablesRootNode.getLocalizedString("CTL_Variables_root");
        }
        this.setDisplayName(name);
        this.setName("JavaVariablesRootNode");
        this.setIconBase(ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariablesRootNode");
    }

    public Node.Handle getHandle() {
        return new VariablesHandle();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VariablesHandle
    implements Node.Handle {
        static final long serialVersionUID = -45182213487259891L;

        private VariablesHandle() {
        }

        public Node getNode() {
            return NodesRegistry.getNode("localsRootNode", new Object[0]);
        }
    }

    static class VRListener
    implements PropertyChangeListener {
        private CoreDebugger debugger;
        private AbstractThread currentThread;
        private WeakReference node;
        protected static String stdIcon = JavaVariablesRootNode.access$200();
        protected static String pendingIcon = JavaVariablesRootNode.access$300();

        VRListener(Node node, CoreDebugger debugger) {
            this.debugger = debugger;
            this.node = new WeakReference<Node>(node);
            Validator validator = ((ValidatorHolder)((Object)debugger)).getValidator();
            validator.addPropertyChangeListener(this);
            debugger.addPropertyChangeListener(this);
            AbstractThread t = debugger.getCurrentThread();
            if (t instanceof CallStackProducer) {
                this.currentThread = t;
                this.currentThread.addPropertyChangeListener(this);
            }
        }

        JavaVariablesRootNode getNode() {
            JavaVariablesRootNode wrn = (JavaVariablesRootNode)((Object)this.node.get());
            if (wrn != null) {
                return wrn;
            }
            this.destroy();
            return null;
        }

        void destroy() {
            Validator validator = ((ValidatorHolder)((Object)this.debugger)).getValidator();
            validator.removePropertyChangeListener(this);
            this.debugger.removePropertyChangeListener(this);
            if (this.currentThread != null) {
                this.currentThread.removePropertyChangeListener(this);
            }
            this.currentThread = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            JavaVariablesRootNode node = this.getNode();
            if (node == null) {
                return;
            }
            if (e.getSource() instanceof Validator) {
                node.setIconBase(((Validator)e.getSource()).isValidated() ? ICON_BASE : ICON_PENDING_VARIABLES);
                return;
            }
            if (e.getSource() instanceof CoreDebugger && e.getPropertyName() == "currentThread") {
                AbstractThread t;
                if (this.currentThread != null) {
                    this.currentThread.removePropertyChangeListener(this);
                }
                this.currentThread = t = this.debugger.getCurrentThread();
                if (t instanceof CallStackProducer) {
                    this.currentThread.addPropertyChangeListener(this);
                }
                ((VariablesRootChildren)node.getChildren()).validate();
            } else if (e.getSource() instanceof CallStackProducer && (e.getPropertyName() == "callstack" || e.getPropertyName() == "currentCallstackFrameIndex")) {
                ((VariablesRootChildren)node.getChildren()).validate();
            }
        }
    }

    private static final class VariablesRootChildren
    extends Children.Keys
    implements LeafRefresher,
    Validator.Object {
        private VRListener l;
        private CoreDebugger debugger;

        private VariablesRootChildren() {
        }

        protected Node[] createNodes(Object key) {
            Node node = DebuggerNode.createNode(key, new Object[]{key, new Integer(1)});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        protected void addNotify() {
            this.debugger = Register.getCoreDebugger();
            this.l = new VRListener(this.getNode(), this.debugger);
            Validator validator = ((ValidatorHolder)((Object)this.debugger)).getValidator();
            validator.add(this);
            this.validate();
        }

        protected void removeNotify() {
            this.l.destroy();
            Validator validator = ((ValidatorHolder)((Object)this.debugger)).getValidator();
            validator.remove(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void validate() {
            HashMap newLocals = new HashMap();
            Object[] variables = new AbstractVariable[]{};
            Object o = this.debugger.getCurrentThread();
            JavaVariablesRootNode n = (JavaVariablesRootNode)this.getNode();
            if (o != null) {
                if (o instanceof CallStackProducer) {
                    Location oo;
                    int i = ((CallStackProducer)o).getCurrentCallStackFrameIndex();
                    Location[] ls = ((CallStackProducer)o).getCallStack();
                    if (i >= 0 && i < ls.length && (oo = ls[i]) instanceof VariablesProducer) {
                        o = oo;
                    }
                }
                if (o instanceof VariablesProducer) {
                    variables = ((VariablesProducer)o).getVariablesFilter().getVariables((VariablesProducer)o);
                    Arrays.sort(variables, JavaVariableNode.variablesComparator);
                }
            }
            this.setKeys(variables);
        }

        public boolean canRemove() {
            return false;
        }

        public void refreshMyKey(Object key) {
            this.refreshKey(key);
        }
    }
}

