/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.io.IOException;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaWatch;
import org.netbeans.modules.debugger.support.java.nodes.JavaVariableNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class JavaWatchNode
extends JavaVariableNode {
    static final long serialVersionUID = 7100312323961302436L;
    protected static String ICON_BASE = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateVariableAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisplayAsAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;

    public JavaWatchNode(JavaWatch watch) {
        super(watch);
        this.setIconBase(ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerWatchNode");
    }

    public boolean canDestroy() {
        return true;
    }

    public SystemAction[] getActions() {
        int i = 0;
        int k = this.getDisplayAsActions().length > 0 ? 8 : 6;
        SystemAction[] sa = new SystemAction[k];
        sa[i++] = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateVariableAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateVariableAction = JavaWatchNode.class$("org.netbeans.modules.debugger.support.actions.CreateVariableAction")) : class$org$netbeans$modules$debugger$support$actions$CreateVariableAction));
        sa[i++] = null;
        sa[i++] = SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JavaWatchNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction));
        sa[i++] = null;
        if (this.getDisplayAsActions().length > 0) {
            sa[i++] = SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisplayAsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisplayAsAction = JavaWatchNode.class$("org.netbeans.modules.debugger.support.actions.DisplayAsAction")) : class$org$netbeans$modules$debugger$support$actions$DisplayAsAction));
            sa[i++] = null;
        }
        sa[i++] = SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JavaWatchNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction));
        sa[i++] = SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JavaWatchNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        return sa;
    }

    public void destroy() throws IOException {
        if (this.variable == null) {
            return;
        }
        this.getWatch().remove();
        super.destroy();
    }

    protected void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.setValue("helpID", "NetbeansDebuggerWatchesPropertiesSheet");
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaWatchNode.class$("java.lang.String")) : class$java$lang$String, "variableName", JavaVariableNode.getLocalizedString("PROP_watch_name"), JavaVariableNode.getLocalizedString("HINT_watch_name"), "getWatchName", "setWatchName"));
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaWatchNode.class$("java.lang.String")) : class$java$lang$String, "type", JavaVariableNode.getLocalizedString("PROP_watch_type"), JavaVariableNode.getLocalizedString("HINT_watch_type"), "getVariableType", null));
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaWatchNode.class$("java.lang.String")) : class$java$lang$String, "type", JavaVariableNode.getLocalizedString("PROP_watch_inner_type"), JavaVariableNode.getLocalizedString("HINT_watch_inner_type"), "getVariableInnerType", null));
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaWatchNode.class$("java.lang.String")) : class$java$lang$String, "asText", JavaVariableNode.getLocalizedString("PROP_watch_value"), JavaVariableNode.getLocalizedString("HINT_watch_value"), "getVariableAsText", "setWatchValue"));
        ps.put(Utils.createProperty(this, Boolean.TYPE, "inScope", JavaVariableNode.getLocalizedString("PROP_watch_in_scope"), JavaVariableNode.getLocalizedString("HINT_watch_in_scope"), "isWatchInScope", null));
        VariablesFilter filter = this.variable.getVariablesFilter();
        Node.Property[] properties = filter.getProperties(this.variable);
        if (properties != null) {
            int x = 0;
            while (x < properties.length) {
                ps.put(properties[x]);
                ++x;
            }
        }
        this.setSheet(sheet);
    }

    public String getWatchName() {
        return this.getWatch().getVariableName();
    }

    public void setWatchName(String name) {
        this.getWatch().setVariableName(name.trim());
    }

    public void setWatchValue(String value) {
        try {
            this.variable.setAsText(value);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public boolean isWatchInScope() {
        return this.getWatch().isInScope();
    }

    JavaWatch getWatch() {
        return (JavaWatch)this.variable;
    }

    public String computeName() {
        String errorMessage = this.getWatch().getErrorMessage();
        if (errorMessage != null) {
            return this.getWatch().getVariableName() + " = >" + errorMessage + "<";
        }
        return super.computeName();
    }

    public void createVariable() {
        JavaVariable var = (JavaVariable)this.getWatch().getVariable();
        if (var == null) {
            return;
        }
        DebuggerSupport d = (DebuggerSupport)Register.getCoreDebugger();
        JavaVariable fixedVar = var.createFixedVariable();
        if (fixedVar instanceof AbstractWatch) {
            d.addWatch((AbstractWatch)((Object)fixedVar));
        }
    }

    public boolean canCreateVariable() {
        return this.getWatch().isInScope();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

