/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.nodes.ClassNode;
import org.netbeans.modules.debugger.support.java.nodes.ConstructorNode;
import org.netbeans.modules.debugger.support.java.nodes.FieldNode;
import org.netbeans.modules.debugger.support.java.nodes.JavaVariableNode;
import org.netbeans.modules.debugger.support.java.nodes.MethodNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;

class LoadedClassFactory
extends DefaultFactory {
    private ClassNode node;
    private JavaClass clazz;

    public LoadedClassFactory(JavaClass clazz) {
        super(false);
        this.clazz = clazz;
    }

    public Children createChildren(JavaClass clazz, ClassElement element) {
        Children children = this.createClassChildren(element, (ElementNodeFactory)this);
        JavaVariable loader = clazz.getClassLoader();
        if (loader != null) {
            children.add(new Node[]{new JavaVariableNode(loader)});
        }
        return children;
    }

    public Node createClassNode(ClassElement element) {
        JavaClass inner = this.clazz.findInnerClass(element);
        if (inner != null) {
            return new ClassNode(inner, element, new LoadedClassFactory(inner));
        }
        return new AbstractNode(Children.LEAF);
    }

    public Node createConstructorNode(ConstructorElement element) {
        return new ConstructorNode(element, false, this.clazz.getName());
    }

    public Node createMethodNode(MethodElement element) {
        return new MethodNode(element, false, this.clazz.getName());
    }

    public Node createFieldNode(FieldElement element) {
        return new FieldNode(this.clazz, element, false);
    }
}

