/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.modules.debugger.support.java.JavaClass;

class PackageContent {
    private String name;
    private boolean changed;
    private Hashtable classes = new Hashtable();
    private Hashtable packages = new Hashtable();

    public PackageContent(String name) {
        this.name = name;
        this.changed = true;
    }

    public void add(JavaClass clazz) {
        this.add(clazz, null);
    }

    private void add(JavaClass clazz, String packageName) {
        if (packageName == null) {
            packageName = clazz.getName();
        }
        if (packageName.indexOf(36) > -1) {
            return;
        }
        int index = packageName.indexOf(46);
        if (index == -1) {
            Element el = (Element)this.classes.get(clazz);
            if (el == null) {
                this.classes.put(clazz, new Element(clazz));
                this.changed = true;
            } else {
                el.confirmed = true;
            }
        } else {
            String subPackageName = packageName.substring(0, index);
            PackageContent subPackage = (PackageContent)this.packages.get(subPackageName);
            if (subPackage == null) {
                subPackage = new PackageContent(this.name.concat(".").concat(subPackageName));
                this.packages.put(subPackageName, subPackage);
                this.changed = true;
            }
            subPackage.add(clazz, packageName.substring(index + 1));
        }
    }

    public String getName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public String getFullName() {
        return this.name;
    }

    public PackageContent getSubContent(String name) {
        return (PackageContent)this.packages.get(name);
    }

    public boolean isEmpty() {
        return this.packages.size() == 0 && this.classes.size() == 0;
    }

    public Object[] getContent() {
        Object[] res = new Object[this.classes.size() + this.packages.size()];
        int index = 0;
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            res[index++] = enumeration.nextElement();
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            res[index++] = ((Element)enumeration.nextElement()).clazz;
        }
        return res;
    }

    public void reorganize() {
        Enumeration enumeration = this.packages.elements();
        while (enumeration.hasMoreElements()) {
            PackageContent sub = (PackageContent)enumeration.nextElement();
            sub.reorganize();
            if (!sub.isEmpty()) continue;
            this.packages.remove(sub.getName());
            this.changed = true;
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            Element el = (Element)enumeration.nextElement();
            if (!el.newOne && !el.confirmed) {
                this.classes.remove(el.clazz);
                this.changed = true;
                continue;
            }
            el.newOne = false;
            el.confirmed = false;
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public void clearChangedFlag() {
        this.changed = false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PackageContent)) {
            return false;
        }
        return this.name.equals(((PackageContent)o).getFullName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private class Element {
        public JavaClass clazz;
        public boolean confirmed;
        public boolean newOne;

        public Element(JavaClass c) {
            this.clazz = c;
            this.confirmed = false;
            this.newOne = true;
        }
    }
}

