/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.nodes.ClassNode;
import org.netbeans.modules.debugger.support.java.nodes.LoadedClassFactory;
import org.netbeans.modules.debugger.support.java.nodes.PackageContent;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;

public class PackageNode
extends AbstractNode {
    static final long serialVersionUID = -5432332123422231L;
    private static String ICON_BASE = "org/openide/resources/defaultFolder";
    private static String ICON_OPENED = "org/openide/resources/defaultFolderOpen";
    private String name;
    protected PackageContent content;
    private static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof JavaClass) {
                if (o2 instanceof PackageContent) {
                    return 1;
                }
                return ((JavaClass)o1).getClassName().compareToIgnoreCase(((JavaClass)o2).getClassName());
            }
            if (o2 instanceof JavaClass) {
                return -1;
            }
            return ((PackageContent)o1).getName().compareToIgnoreCase(((PackageContent)o2).getName());
        }
    };

    public PackageNode(PackageContent content) {
        super((Children)new PackageChildren());
        this.content = content;
        this.init();
    }

    protected void init() {
        this.name = this.content.getName();
        this.setDisplayName(this.name);
        this.setName(this.name);
        this.setIconBase(ICON_BASE);
        this.changeChildren(this.content);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerPackageNode");
    }

    void changeChildren(PackageContent content) {
        ((PackageChildren)this.getChildren()).setContent(content);
    }

    static final class PackageChildren
    extends Children.Keys {
        private boolean inited = false;

        PackageChildren() {
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof PackageContent) {
                return new Node[]{new PackageNode((PackageContent)key)};
            }
            if (key instanceof JavaClass) {
                return new Node[]{new ClassNode((JavaClass)key, ((JavaClass)key).toClassElement(), new LoadedClassFactory((JavaClass)key))};
            }
            return new Node[0];
        }

        protected void addNotify() {
            super.addNotify();
            this.inited = true;
        }

        private void setMyKeys(Object[] keys) {
            this.setKeys(keys);
        }

        void setContent(PackageContent content) {
            if (content.changed()) {
                Object[] keys = content.getContent();
                Arrays.sort(keys, comparator);
                this.setKeys(keys);
            }
            content.clearChangedFlag();
            if (this.inited) {
                Node[] nodes = (Node[])Children.MUTEX.writeAccess(new Mutex.Action(this){
                    private final /* synthetic */ PackageChildren this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return this.this$0.getNodes();
                    }
                });
                int x = 0;
                while (x < nodes.length) {
                    if (nodes[x] instanceof PackageNode) {
                        PackageNode node = (PackageNode)nodes[x];
                        node.changeChildren(content.getSubContent(((FeatureDescriptor)((Object)node)).getName()));
                    } else if (nodes[x] instanceof ClassNode) {
                        ((ClassNode)nodes[x]).update();
                    }
                    ++x;
                }
            }
        }
    }
}

