/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.netbeans.modules.debugger.support.actions.SessionCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class ADSessionNode
extends AbstractNode
implements SessionCookie,
SwitchOnCookie {
    static final long serialVersionUID = -4736315827522307464L;
    public static final String PROP_SESSION_NAME = "sessionName";
    public static final String PROP_LOCATION_NAME = "locationName";
    public static final String PROP_STATE = "state";
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/sessionsView/Session";
    private static final String ICON_BASE_CURRENT = "org/netbeans/modules/debugger/resources/sessionsView/CurrentSession";
    private static SystemAction[] staticActions;
    private final AbstractDebugger debugger;
    private EnterpriseDebugger coreDebugger = null;
    private Listener listener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FinishSessionAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$java$lang$String;

    public ADSessionNode(AbstractDebugger d) {
        super(Children.LEAF);
        this.debugger = d;
        this.update();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.listener = new Listener(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerSessionNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction = ADSessionNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnSessionAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FinishSessionAction == null ? (class$org$netbeans$modules$debugger$support$actions$FinishSessionAction = ADSessionNode.class$("org.netbeans.modules.debugger.support.actions.FinishSessionAction")) : class$org$netbeans$modules$debugger$support$actions$FinishSessionAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ADSessionNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ADSessionNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction = ADSessionNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnSessionAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnSessionAction));
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.setValue("helpID", "NetbeansDebuggerSessionsPropertiesSheet");
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = ADSessionNode.class$("java.lang.String")) : class$java$lang$String, PROP_SESSION_NAME, DebuggerNode.getLocalizedString("PROP_session_name"), DebuggerNode.getLocalizedString("HINT_session_name"), "getProcessName", null));
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = ADSessionNode.class$("java.lang.String")) : class$java$lang$String, "location", DebuggerNode.getLocalizedString("PROP_location_name"), DebuggerNode.getLocalizedString("HINT_location_name"), "getLocationName", null));
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = ADSessionNode.class$("java.lang.String")) : class$java$lang$String, "sessionState", DebuggerNode.getLocalizedString("PROP_state"), DebuggerNode.getLocalizedString("HINT_state"), "getState", null));
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = ADSessionNode.class$("java.lang.String")) : class$java$lang$String, "language", DebuggerNode.getLocalizedString("PROP_session_language_column_name"), DebuggerNode.getLocalizedString("HINT_session_language_column_name"), "getState", null));
        this.setSheet(sheet);
    }

    public void destroy() throws IOException {
        super.destroy();
        this.listener.destroy();
        this.listener = null;
        this.coreDebugger = null;
    }

    public boolean isCurrent() {
        return this.getCoreDebugger().getCurrentDebugger() == this.debugger;
    }

    public boolean canSetCurrent() {
        return !this.isCurrent();
    }

    public void setCurrent() {
        this.getCoreDebugger().setCurrentDebugger(this.debugger);
    }

    private EnterpriseDebugger getCoreDebugger() {
        if (this.coreDebugger != null) {
            return this.coreDebugger;
        }
        this.coreDebugger = (EnterpriseDebugger)Register.getCoreDebugger();
        return this.coreDebugger;
    }

    public String getProcessName() {
        DebuggerInfo di = this.debugger.getDebuggerInfo();
        return di instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)di).getProcessName() : "";
    }

    public String getLocationName() {
        DebuggerInfo di = this.debugger.getDebuggerInfo();
        return di instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)di).getLocationName() : "localhost";
    }

    public String getLanguage() {
        return this.debugger.getCurrentLanguage();
    }

    public void setLanguage(String language) {
        this.debugger.switchLanguage(language);
    }

    public void finish() {
        try {
            this.getCoreDebugger().setSessionPersistent(this.debugger, false);
            this.debugger.finishDebugger();
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    private void update() {
        this.setIconBase(this.isCurrent() ? ICON_BASE_CURRENT : ICON_BASE);
        DebuggerInfo di = this.debugger.getDebuggerInfo();
        if (di == null) {
            return;
        }
        if (!(di instanceof AbstractDebuggerInfo)) {
            return;
        }
        String n = ((AbstractDebuggerInfo)di).getProcessName();
        this.setDisplayName(n);
        this.setName(n);
    }

    public String getState() {
        switch (this.debugger.getState()) {
            case 2: {
                return DebuggerNode.getLocalizedString("CTL_Starting");
            }
            case 3: {
                return DebuggerNode.getLocalizedString("CTL_Running");
            }
            case 4: {
                if (this.debugger.getLastAction() == 1) {
                    return DebuggerNode.getLocalizedString("CTL_Stopped_on_breakpoint");
                }
                return DebuggerNode.getLocalizedString("CTL_Stopped");
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference node;
        private CoreDebugger coreDebugger;
        private AbstractDebugger debugger;

        Listener(ADSessionNode n) {
            this.node = new WeakReference<ADSessionNode>(n);
            this.coreDebugger = n.getCoreDebugger();
            this.coreDebugger.addPropertyChangeListener(this);
            this.debugger = n.debugger;
            this.debugger.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "currentDebugger" || e.getPropertyName() == ADSessionNode.PROP_STATE) {
                ADSessionNode sn = this.getSessionNode();
                if (sn == null) {
                    return;
                }
                sn.update();
            }
        }

        private ADSessionNode getSessionNode() {
            ADSessionNode sn = (ADSessionNode)this.node.get();
            if (sn == null) {
                this.destroy();
            }
            return sn;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            this.coreDebugger.removePropertyChangeListener(this);
        }
    }
}

