/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.nodes.BreakpointsRootNode;
import org.netbeans.modules.debugger.support.nodes.CopyPasteSupport;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Breakpoint;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public final class BreakpointNode
extends AbstractNode
implements GoToSourceCookie {
    static final long serialVersionUID = -8680621542479107034L;
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_CLASS_NAME = "className";
    public static final String PROP_METHOD_NAME = "methodName";
    private final CoreBreakpoint breakpoint;
    private AbstractDebugger debugger = null;
    private BreakpointGroup group = null;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DeleteAllAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToSourceAction;

    public BreakpointNode(CoreBreakpoint breakpoint) {
        super(Children.LEAF);
        this.breakpoint = breakpoint;
        this.init();
    }

    public BreakpointNode(CoreBreakpoint breakpoint, BreakpointGroup group) {
        super((Children)new BreakpointsRootNode.BreakpointGroupChildren(group));
        this.breakpoint = breakpoint;
        this.group = group;
        this.init();
    }

    private void init() {
        this.debugger = Register.getCoreDebugger();
        this.getCookieSet().add((Node.Cookie)this);
        this.changeEvent();
        this.breakpoint.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && (propertyName.equals("event") || propertyName.equals("actions"))) {
                    BreakpointNode.this.changeEvent();
                } else {
                    BreakpointNode.this.propertyChanged(propertyName, e.getOldValue(), e.getNewValue());
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointNode");
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        CoreBreakpoint.Event be = this.breakpoint.getEvent(this.debugger);
        if (be != null) {
            ps.put(be.getProperties());
            ps.setValue("helpID", be.getHelpCtx().getHelpID());
        } else {
            ps.setValue("helpID", "NetbeansDebuggerBreakpointsPropertiesSheet");
        }
        ps.put(Utils.createProperty(this.breakpoint, Boolean.TYPE, "enabled", DebuggerNode.getLocalizedString("PROP_breakpoint_enabled"), DebuggerNode.getLocalizedString("HINT_breakpoint_enabled"), "isEnabled", "setEnabled"));
        ps.put(Utils.createProperty(this.breakpoint, Boolean.TYPE, "valid", DebuggerNode.getLocalizedString("PROP_breakpoint_valid"), DebuggerNode.getLocalizedString("HINT_breakpoint_valid"), "isValid", null));
        CoreBreakpoint.Action[] ba = this.breakpoint.getActions();
        if (ba != null) {
            int k = ba.length;
            int i = 0;
            while (i < k) {
                ps.put(ba[i].getProperties());
                ++i;
            }
        }
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public SystemAction[] getContextActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.CreateBreakpointGroupAction")) : class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.EnableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.DisableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DeleteAllAction == null ? (class$org$netbeans$modules$debugger$support$actions$DeleteAllAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.DeleteAllAction")) : class$org$netbeans$modules$debugger$support$actions$DeleteAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BreakpointNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public SystemAction[] getActions() {
        if (this.breakpoint.getLine() == null) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BreakpointNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BreakpointNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = BreakpointNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BreakpointNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.breakpoint.remove();
        super.destroy();
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = BreakpointNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction));
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCut() {
        ExTransferable.Single t = NodeTransfer.transferable((Node)this, (int)4);
        ExTransferable xt = ExTransferable.create((Transferable)t);
        xt.put(NodeTransfer.createPaste((NodeTransfer.Paste)new CopyPasteSupport.BreakpointPaste(this.breakpoint, true)));
        return xt;
    }

    public void goToSource() {
        Line l = this.breakpoint.getLine();
        if (l == null) {
            return;
        }
        l.show(2);
    }

    public boolean canGoToSource() {
        return this.breakpoint.getLine() != null;
    }

    Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    void changeEvent() {
        CoreBreakpoint.Event event = this.breakpoint.getEvent(this.debugger);
        if (event == null) {
            return;
        }
        String s = event.getDisplayName();
        this.setName(s);
        this.setDisplayName(s);
        s = event.getIconBase();
        if (s == null) {
            s = ICON_BASE;
        }
        this.setIconBase(s);
        this.createProperties();
    }

    void propertyChanged(String propName, Object o, Object n) {
        CoreBreakpoint.Event event = this.breakpoint.getEvent(this.debugger);
        if (event == null) {
            return;
        }
        String s = event.getDisplayName();
        this.setName(s);
        this.setDisplayName(s);
        s = event.getIconBase();
        if (s == null) {
            s = ICON_BASE;
        }
        this.setIconBase(s);
        this.firePropertyChange(propName, o, n);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

