/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.BreakpointGroup;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.BreakpointGroupSupport;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.actions.BreakpointsRootCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Breakpoint;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public final class BreakpointsRootNode
extends AbstractNode
implements BreakpointsRootCookie {
    static final long serialVersionUID = -6708027507109804744L;
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private BreakpointGroup group;
    private boolean isMain = true;
    private boolean isInTree;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DeleteAllAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$java$lang$String;

    public BreakpointsRootNode() {
        this(null, false);
    }

    public BreakpointsRootNode(boolean isInTree) {
        this(null, isInTree);
    }

    public BreakpointsRootNode(BreakpointGroup group, boolean isInTree) {
        super((Children)new BreakpointGroupChildren(group));
        this.isInTree = isInTree;
        if (group == null) {
            group = Register.getCoreDebugger().getRootBreakpointGroup();
        } else {
            this.isMain = false;
        }
        this.group = group;
        String name = null;
        name = this.isMain ? (isInTree ? DebuggerNode.getLocalizedString("PROP_breakpoints_column_name") : DebuggerNode.getLocalizedString("CTL_Breakpoints_group_root")) : group.getName();
        this.setShortDescription(name);
        this.setDisplayName(name);
        this.setName("BreakpointsRootNode");
        this.setIconBase(ICON_BASE);
        if (group instanceof BreakpointGroupSupport) {
            this.getCookieSet().add((Node.Cookie)this);
        }
        this.createProperties();
        group.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName == "name") {
                    String newName = (String)e.getNewValue();
                    BreakpointsRootNode.this.setName(newName);
                    BreakpointsRootNode.this.setDisplayName(newName);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointsRootNode");
    }

    private void readObject(ObjectInputStream obis) throws IOException, ClassNotFoundException, NotActiveException {
        obis.defaultReadObject();
    }

    public Node.Handle getHandle() {
        return new BreakpointsHandle();
    }

    public SystemAction[] getActions() {
        if (this.isMain) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.CreateBreakpointGroupAction")) : class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.EnableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.DisableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DeleteAllAction == null ? (class$org$netbeans$modules$debugger$support$actions$DeleteAllAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.DeleteAllAction")) : class$org$netbeans$modules$debugger$support$actions$DeleteAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BreakpointsRootNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointsRootNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointsRootNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction == null ? (class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.CreateBreakpointGroupAction")) : class$org$netbeans$modules$debugger$support$actions$CreateBreakpointGroupAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.EnableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$EnableAllBreakpointsAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction == null ? (class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.DisableAllBreakpointsAction")) : class$org$netbeans$modules$debugger$support$actions$DisableAllBreakpointsAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = BreakpointsRootNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BreakpointsRootNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BreakpointsRootNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BreakpointsRootNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public SystemAction[] getContextActions() {
        return this.getActions();
    }

    public String getBreakpointGroupName() {
        return this.group.getName();
    }

    public void setBreakpointGroupName(String name) {
        if (!(this.group instanceof BreakpointGroupSupport)) {
            throw new IllegalArgumentException();
        }
        ((BreakpointGroupSupport)this.group).setName(name.trim());
    }

    private void createProperties() {
        if (this.isMain) {
            return;
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.setValue("helpID", "NetbeansDebuggerBreakpointsPropertiesSheet");
        ps.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = BreakpointsRootNode.class$("java.lang.String")) : class$java$lang$String, "name", DebuggerNode.getLocalizedString("PROP_breakpoint_group_name"), DebuggerNode.getLocalizedString("HINT_breakpoint_group_name"), "getBreakpointGroupName", this.group instanceof BreakpointGroupSupport ? "setBreakpointGroupName" : null));
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public boolean canDestroy() {
        return !this.isMain && this.group instanceof BreakpointGroupSupport;
    }

    public void destroy() throws IOException {
        ((BreakpointGroupSupport)this.group).delete();
        super.destroy();
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = BreakpointsRootNode.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
    }

    public void deleteAll() {
        BreakpointGroup[] g = this.group.getGroups();
        int x = 0;
        while (x < g.length) {
            if (g[x] instanceof BreakpointGroupSupport) {
                ((BreakpointGroupSupport)g[x]).delete();
            }
            ++x;
        }
        CoreBreakpoint[] b = this.group.getBreakpoints();
        x = 0;
        while (x < b.length) {
            b[x].remove();
            ++x;
        }
    }

    public void enableAll() {
        ((BreakpointGroupSupport)this.group).setEnabled(true);
    }

    public void disableAll() {
        ((BreakpointGroupSupport)this.group).setEnabled(false);
    }

    public BreakpointGroup getGroup() {
        return this.group;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BreakpointsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4518262935887259653L;

        private BreakpointsHandle() {
        }

        public Node getNode() {
            Node n = NodesRegistry.getNode("breakpointsRootNode", new Object[0]);
            return n;
        }
    }

    static final class BreakpointGroupChildren
    extends Children.Keys {
        private BreakpointGroup group = null;
        private ArrayList c = new ArrayList();
        private AbstractDebugger debugger;
        private BreakpointComparator breakpointComparator = new BreakpointComparator();
        private GroupListener listener;

        BreakpointGroupChildren(BreakpointGroup group) {
            this.group = group;
        }

        protected void addNotify() {
            this.debugger = Register.getCoreDebugger();
            BreakpointGroup rootGroup = ((BreakpointProducer)((Object)this.debugger)).getRootBreakpointGroup();
            if (this.group == null) {
                this.group = rootGroup;
            }
            this.listener = new GroupListener(this.getNode(), this.group);
        }

        protected void removeNotify() {
            this.group.removePropertyChangeListener(this.listener);
            this.listener = null;
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refresh(Object[] keys) {
            Arrays.sort(keys, this.breakpointComparator);
            this.setKeys(keys);
        }

        private void refresh(Object key) {
            this.refreshKey(key);
        }

        private static boolean breakpointVisible(Breakpoint br) {
            return !br.isHidden() && (!(br instanceof CoreBreakpoint) || ((CoreBreakpoint)br).getEvent() != null);
        }

        protected Node[] createNodes(Object key) {
            Node node;
            if (key instanceof Breakpoint && !BreakpointGroupChildren.breakpointVisible((Breakpoint)key)) {
                return new Node[0];
            }
            if (key instanceof BreakpointGroupSupport && ((BreakpointGroupSupport)key).getTopBreakpoint() != null) {
                CoreBreakpoint brk = ((BreakpointGroupSupport)key).getTopBreakpoint();
                node = NodesRegistry.getNode(brk, new Object[]{brk, key});
            } else {
                node = key instanceof BreakpointGroup ? NodesRegistry.getNode(key, new Object[]{key, ((BreakpointsRootNode)this.getNode()).isInTree ? Boolean.TRUE : Boolean.FALSE}) : NodesRegistry.getNode(key);
            }
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        private class BreakpointComparator
        implements Comparator,
        Serializable {
            private BreakpointComparator() {
            }

            public int compare(Object o1, Object o2) {
                Line l2;
                Line l1;
                CoreBreakpoint topBreakpoint;
                boolean firstIsGroup = false;
                boolean secondIsGroup = false;
                if (o1 instanceof BreakpointGroupSupport) {
                    topBreakpoint = ((BreakpointGroupSupport)o1).getTopBreakpoint();
                    if (topBreakpoint != null) {
                        o1 = topBreakpoint;
                    } else {
                        firstIsGroup = true;
                    }
                }
                if (o2 instanceof BreakpointGroupSupport) {
                    topBreakpoint = ((BreakpointGroupSupport)o2).getTopBreakpoint();
                    if (topBreakpoint != null) {
                        o2 = topBreakpoint;
                    } else {
                        secondIsGroup = true;
                    }
                }
                if (firstIsGroup || secondIsGroup) {
                    if (!firstIsGroup || !secondIsGroup) {
                        return firstIsGroup ? 1 : -1;
                    }
                    return ((BreakpointGroup)o1).getName().compareToIgnoreCase(((BreakpointGroup)o2).getName());
                }
                CoreBreakpoint.Event event1 = null;
                CoreBreakpoint.Event event2 = null;
                String s1 = null;
                String s2 = null;
                if (o1 instanceof CoreBreakpoint) {
                    event1 = ((CoreBreakpoint)o1).getEvent(BreakpointGroupChildren.this.debugger);
                    if (event1 == null) {
                        s1 = "";
                    }
                } else {
                    s1 = ((Breakpoint)o1).getClassName();
                }
                if (o2 instanceof CoreBreakpoint) {
                    event2 = ((CoreBreakpoint)o2).getEvent(BreakpointGroupChildren.this.debugger);
                    if (event2 == null) {
                        s2 = "";
                    }
                } else {
                    s2 = ((Breakpoint)o2).getClassName();
                }
                if (s1 == null && s2 == null && event1 instanceof LineBreakpointEvent && event2 instanceof LineBreakpointEvent && (l1 = ((LineBreakpointEvent)event1).getLine()) != null && (l2 = ((LineBreakpointEvent)event2).getLine()) != null) {
                    return l1.getLineNumber() - l2.getLineNumber();
                }
                if (s1 == null) {
                    s1 = event1.getDisplayName();
                }
                if (s2 == null) {
                    s2 = event2.getDisplayName();
                }
                return s1.compareToIgnoreCase(s2);
            }
        }

        static class GroupListener
        implements PropertyChangeListener {
            private BreakpointGroup group;
            private WeakReference node;
            private List breakpoints = new ArrayList();
            private List groups = new ArrayList();
            private Breakpoint topBreakpoint = null;

            private GroupListener(Node node, BreakpointGroup group) {
                this.group = group;
                this.node = new WeakReference<Node>(node);
                group.addPropertyChangeListener(this);
                this.refreshAll(node);
            }

            Node getNode() {
                Node wrn = (Node)this.node.get();
                if (wrn != null) {
                    return wrn;
                }
                this.group.removePropertyChangeListener(this);
                int k = this.breakpoints.size();
                int i = 0;
                while (i < k) {
                    ((Breakpoint)this.breakpoints.get(i)).removePropertyChangeListener((PropertyChangeListener)this);
                    ++i;
                }
                return null;
            }

            public synchronized void propertyChange(PropertyChangeEvent e) {
                Node node = this.getNode();
                if (node == null) {
                    return;
                }
                String propertyName = e.getPropertyName();
                Object source = e.getSource();
                if (propertyName == null || source == null) {
                    return;
                }
                if (source instanceof Breakpoint) {
                    boolean visibilityChanged = false;
                    boolean madeVisible = true;
                    if (propertyName.equals("hidden") && ((CoreBreakpoint)source).getEvent() != null) {
                        visibilityChanged = true;
                        madeVisible = e.getNewValue().equals(Boolean.TRUE);
                    } else if (propertyName.equals("event") && !((CoreBreakpoint)source).isHidden()) {
                        Object oldValue = e.getOldValue();
                        Object newValue = e.getNewValue();
                        if (oldValue == null && newValue != null) {
                            visibilityChanged = true;
                            madeVisible = true;
                        } else if (oldValue != null && newValue == null) {
                            visibilityChanged = true;
                            madeVisible = false;
                        }
                    }
                    if (visibilityChanged) {
                        if (madeVisible) {
                            this.refreshAll(node);
                        } else {
                            ((BreakpointGroupChildren)node.getChildren()).refresh((Breakpoint)source);
                        }
                    }
                    return;
                }
                if (source instanceof BreakpointGroup) {
                    if (source == this.group) {
                        if (propertyName.equals("breakpoints")) {
                            Breakpoint br = (Breakpoint)e.getNewValue();
                            if (br != null) {
                                if (!BreakpointGroupChildren.breakpointVisible(br)) {
                                    br.addPropertyChangeListener((PropertyChangeListener)this);
                                    this.breakpoints.add(br);
                                    return;
                                }
                            } else {
                                br = (Breakpoint)e.getOldValue();
                                if (!BreakpointGroupChildren.breakpointVisible(br)) {
                                    br.removePropertyChangeListener((PropertyChangeListener)this);
                                    this.breakpoints.remove(br);
                                    return;
                                }
                            }
                            this.refreshAll(node);
                            return;
                        }
                        if (propertyName.equals("groups")) {
                            this.refreshAll(node);
                            return;
                        }
                    } else if (propertyName.equals("topBreakpoint")) {
                        ((BreakpointGroupChildren)node.getChildren()).refresh(e.getSource());
                    }
                }
            }

            void refreshAll(Node node) {
                int k = this.breakpoints.size();
                int i = 0;
                while (i < k) {
                    ((Breakpoint)this.breakpoints.get(i)).removePropertyChangeListener((PropertyChangeListener)this);
                    ++i;
                }
                k = this.groups.size();
                i = 0;
                while (i < k) {
                    ((BreakpointGroup)this.groups.get(i)).removePropertyChangeListener(this);
                    ++i;
                }
                if (this.topBreakpoint != null) {
                    this.topBreakpoint.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.breakpoints = new ArrayList<CoreBreakpoint>(Arrays.asList(this.group.getBreakpoints()));
                this.groups = Arrays.asList(this.group.getGroups());
                CoreBreakpoint topBreakpoint = null;
                if (this.group instanceof BreakpointGroupSupport) {
                    topBreakpoint = ((BreakpointGroupSupport)this.group).getTopBreakpoint();
                }
                if (topBreakpoint != null) {
                    this.breakpoints.remove(topBreakpoint);
                }
                k = this.breakpoints.size();
                int kk = this.groups.size();
                Object[] params = new Object[k + kk];
                i = 0;
                while (i < k) {
                    params[i] = this.breakpoints.get(i);
                    ++i;
                }
                i = k;
                while (i < k + kk) {
                    params[i] = this.groups.get(i - k);
                    ++i;
                }
                ((BreakpointGroupChildren)node.getChildren()).refresh(params);
                k = this.breakpoints.size();
                i = 0;
                while (i < k) {
                    ((Breakpoint)this.breakpoints.get(i)).addPropertyChangeListener((PropertyChangeListener)this);
                    ++i;
                }
                k = this.groups.size();
                i = 0;
                while (i < k) {
                    ((BreakpointGroup)this.groups.get(i)).addPropertyChangeListener(this);
                    ++i;
                }
                if (topBreakpoint != null) {
                    topBreakpoint.addPropertyChangeListener(this);
                }
            }
        }
    }
}

