/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LocationNode;
import org.netbeans.modules.debugger.support.nodes.ThreadNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CallStackNode
extends AbstractNode
implements ThreadNode.Refreshable {
    static final long serialVersionUID = -8259352660663524178L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/CallStack";
    private CallStackProducer producer;
    private CallStackListener callStackListener;
    private int index = 0;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$CallStackNode;

    public CallStackNode(AbstractThread producer, AbstractDebugger debugger) {
        super((Children)new CallStackChildren());
        this.producer = (CallStackProducer)((Object)producer);
        String s = NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$CallStackNode == null ? (class$org$netbeans$modules$debugger$support$nodes$CallStackNode = CallStackNode.class$("org.netbeans.modules.debugger.support.nodes.CallStackNode")) : class$org$netbeans$modules$debugger$support$nodes$CallStackNode), (String)"CTL_CallStack");
        this.setDisplayName(s);
        this.setName(s);
        this.setIconBase(ICON_BASE);
        this.callStackListener = new CallStackListener(this);
        producer.addPropertyChangeListener(this.callStackListener);
    }

    public CallStackNode(Location location, CallStackProducer producer, int index, boolean showSubNodes) {
        super((Children)new CallStackChildren());
        this.producer = (CallStackProducer)((Object)location);
        this.index = index;
        String s = location.getLocationName();
        this.setDisplayName(s);
        this.setName(s);
        this.setIconBase(ICON_BASE);
        this.callStackListener = new CallStackListener(this);
        this.producer.addPropertyChangeListener(this.callStackListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerCallStackNode");
    }

    public void refresh() {
        ((CallStackChildren)this.getChildren()).changeChildren();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallStackListener
    implements PropertyChangeListener {
        private WeakReference node;
        private CallStackProducer producer;

        CallStackListener(CallStackNode n) {
            this.node = new WeakReference<CallStackNode>(n);
            this.producer = n.producer;
        }

        public void propertyChange(PropertyChangeEvent e) {
            CallStackNode csn = (CallStackNode)this.node.get();
            if (csn == null) {
                this.producer.removePropertyChangeListener(this);
                return;
            }
            if (e.getPropertyName() != null && e.getPropertyName().equals("callstack")) {
                ((CallStackChildren)csn.getChildren()).changeChildren();
            }
        }
    }

    private static final class CallStackChildren
    extends Children.Keys {
        private boolean init = false;
        private ArrayList keys = new ArrayList();

        private CallStackChildren() {
        }

        protected void addNotify() {
            this.init = true;
            Location[] callStack = ((CallStackNode)this.getNode()).producer.getCallStack();
            int k = callStack.length;
            int i = 0;
            while (i < k) {
                this.keys.add(0, callStack[k - i - 1]);
                ++i;
            }
            this.setKeys(this.keys);
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object loc) {
            Node node = DebuggerNode.createNode(loc, new Object[]{loc, ((CallStackNode)this.getNode()).producer, new Integer(((CallStackNode)this.getNode()).index + this.keys.indexOf(loc)), Boolean.TRUE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void changeChildren() {
            if (!this.init) {
                return;
            }
            Location[] callStack = ((CallStackNode)this.getNode()).producer.getCallStack();
            Node[] node = this.getNodes();
            int stackLength = callStack.length;
            int nodesLength = node.length;
            int k = Math.min(stackLength, nodesLength);
            int i = 0;
            while (i < k) {
                Node n = node[nodesLength - i - 1];
                if (n instanceof LocationNode) {
                    ((LocationNode)n).updateLocation(callStack[stackLength - i - 1]);
                }
                ++i;
            }
            i = k;
            while (i < stackLength) {
                this.keys.add(0, callStack[stackLength - i - 1]);
                ++i;
            }
            i = k;
            while (i < nodesLength) {
                this.keys.remove(nodesLength - i - 1);
                ++i;
            }
            this.setKeys(this.keys);
        }
    }
}

