/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CallStackRootNode
extends AbstractNode {
    static final long serialVersionUID = -8259352660663524178L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/CallStack";
    private AbstractThread thread;
    private ThreadsRoot debugger;
    private CallStackListener callStackListener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode = CallStackRootNode.class$("org.netbeans.modules.debugger.support.nodes.CallStackRootNode")) : class$org$netbeans$modules$debugger$support$nodes$CallStackRootNode), (String)s);
    }

    public CallStackRootNode() {
        this(false);
    }

    public CallStackRootNode(boolean isInTree) {
        super((Children)new CallStackChildren());
        String name = null;
        if (isInTree) {
            name = DebuggerNode.getLocalizedString("PROP_callstack_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_callstack_column_name"));
        } else {
            name = CallStackRootNode.getLocalizedString("CTL_CallStack");
        }
        this.setDisplayName(name);
        this.setName("CallStackRootNode");
        this.setIconBase(ICON_BASE);
        this.debugger = Register.getCoreDebugger();
        this.callStackListener = new CallStackListener(this);
        this.thread = this.debugger.getCurrentThread();
        if (this.thread != null) {
            this.thread.addPropertyChangeListener(this.callStackListener);
        }
        ((AbstractDebugger)((Object)this.debugger)).addPropertyChangeListener(this.callStackListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerCallStackRootNode");
    }

    public Node.Handle getHandle() {
        return new CallStackHandle();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallStackHandle
    implements Node.Handle {
        static final long serialVersionUID = -45182213487259891L;

        private CallStackHandle() {
        }

        public Node getNode() {
            return new CallStackRootNode();
        }
    }

    private static class CallStackListener
    implements PropertyChangeListener {
        private WeakReference node;

        CallStackListener(CallStackRootNode n) {
            this.node = new WeakReference<CallStackRootNode>(n);
        }

        public void propertyChange(PropertyChangeEvent e) {
            CallStackRootNode csn = (CallStackRootNode)((Object)this.node.get());
            if (csn == null) {
                return;
            }
            String propName = e.getPropertyName();
            if (propName == null) {
                return;
            }
            if (propName.equals("currentThread")) {
                if (csn.thread != null) {
                    csn.thread.removePropertyChangeListener(this);
                }
                csn.thread = csn.debugger.getCurrentThread();
                if (csn.thread != null) {
                    csn.thread.addPropertyChangeListener(this);
                }
                ((CallStackChildren)csn.getChildren()).changeChildren();
            } else if (propName.equals("callstack")) {
                ((CallStackChildren)csn.getChildren()).changeChildren();
            }
        }
    }

    private static final class CallStackChildren
    extends Children.Keys {
        private boolean init = false;
        private ArrayList keys = new ArrayList();

        private CallStackChildren() {
        }

        protected void addNotify() {
            this.init = true;
            if (((CallStackRootNode)this.getNode()).thread == null) {
                return;
            }
            CallStackProducer thread = (CallStackProducer)((Object)((CallStackRootNode)this.getNode()).thread);
            Location[] callStack = thread.getCallStackFilter().filterCallStack(thread);
            int k = callStack.length;
            int i = 0;
            while (i < k) {
                this.keys.add(0, callStack[k - i - 1]);
                ++i;
            }
            if (this.keys.size() > 0) {
                this.setKeys(this.keys);
            }
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object loc) {
            Node node = DebuggerNode.createNode(loc, new Object[]{loc, ((CallStackRootNode)this.getNode()).thread, new Integer(this.keys.indexOf(loc)), Boolean.FALSE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        public void changeChildren() {
            if (!this.init) {
                return;
            }
            AbstractThread thread = ((CallStackRootNode)this.getNode()).thread;
            if (thread == null || !(thread instanceof CallStackProducer)) {
                this.setKeys(Collections.EMPTY_SET);
                this.keys = new ArrayList();
                return;
            }
            Location[] callStack = ((CallStackProducer)((Object)thread)).getCallStackFilter().filterCallStack((CallStackProducer)((Object)thread));
            Node[] node = this.getNodes();
            int stackLength = callStack.length;
            int nodesLength = node.length;
            this.keys.clear();
            this.keys.ensureCapacity(stackLength);
            int i = 0;
            while (i < stackLength) {
                this.keys.add(callStack[i]);
                ++i;
            }
            this.setKeys(this.keys);
        }
    }
}

