/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.DebuggerAdapter;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DebuggerNode
extends AbstractNode {
    static final long serialVersionUID = 6394601904375687521L;
    public static final String PROP_SHOW_MESSAGES = "showMessages";
    public static final String PROP_SHOW_IN_EDITOR = "showInEditor";
    public static final String PROP_REMOTE_DEBUGGING = "remoteDebugging";
    public static final String PROP_TOTAL_MEMORY = "totalMemory";
    public static final String PROP_FREE_MEMORY = "freeMemory";
    public static final String PROP_SOURCE_PATH = "sourcePath";
    public static final String PROP_EXCEPTION_CATCH_LIST = "exceptionCatchList";
    public static final String PROP_DEBUGGER_STATE = "debuggerState";
    private static final String ICON_BASE = "org/netbeans/modules/debugger/resources/DebugTab";
    private transient AbstractDebugger debugger;
    private transient DebuggerAdapter debuggerListener;
    private transient PropertyChangeListener topManagetListener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$DebuggerNode;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$DebuggerNode == null ? (class$org$netbeans$modules$debugger$support$nodes$DebuggerNode = DebuggerNode.class$("org.netbeans.modules.debugger.support.nodes.DebuggerNode")) : class$org$netbeans$modules$debugger$support$nodes$DebuggerNode), (String)s);
    }

    public static Node createNode(Object w) {
        Node n = NodesRegistry.getNode(w);
        if (n == null) {
            try {
                n = new BeanNode(w);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    public static Node createNode(Object w, Object[] params) {
        Node n = NodesRegistry.getNode(w, params);
        if (n == null) {
            try {
                n = new BeanNode(w);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    public DebuggerNode() {
        super((Children)new DebuggerChildren());
        String name = DebuggerNode.getLocalizedString("CTL_Debugger");
        this.setDisplayName(name);
        this.setName(name);
        this.setShortDescription(DebuggerNode.getLocalizedString("HINT_Debugger"));
        this.setIconBase(ICON_BASE);
        this.initialize();
    }

    private void initialize() {
        this.createProperties();
        Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DebuggerNode.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger)).addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                DebuggerNode.this.debuggerChanged();
            }
        });
        this.debuggerChanged();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerDebuggerNode");
    }

    protected void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.setValue("helpID", "NetbeansDebuggerNodePropertiesSheet");
        ps.put(Utils.createProperty((Object)this, class$java$lang$String == null ? (class$java$lang$String = DebuggerNode.class$("java.lang.String")) : class$java$lang$String, PROP_DEBUGGER_STATE, DebuggerNode.getLocalizedString("PROP_debugger_state"), DebuggerNode.getLocalizedString("HINT_debugger_state"), "getDebuggerState", null));
        this.setSheet(sheet);
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = DebuggerNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public String getDebuggerState() {
        if (this.debugger == null) {
            return "";
        }
        switch (this.debugger.getState()) {
            case 1: {
                return DebuggerNode.getLocalizedString("VAL_NotRrunning");
            }
            case 2: {
                return DebuggerNode.getLocalizedString("VAL_Starting");
            }
            case 3: {
                return DebuggerNode.getLocalizedString("VAL_Running");
            }
            case 4: {
                return DebuggerNode.getLocalizedString("VAL_Stopped");
            }
        }
        return "";
    }

    void debuggerStateChanged() {
        this.firePropertyChange(null, null, null);
    }

    void debuggerChanged() {
        if (this.debugger != null) {
            this.debugger.removeDebuggerListener(this.debuggerListener);
        }
        this.debugger = Register.getCoreDebugger();
        if (this.debugger == null) {
            return;
        }
        if (this.debuggerListener == null) {
            this.debuggerListener = new DebuggerAdapter(){

                public void debuggerStateChanged(int debuggerState) {
                    DebuggerNode.this.debuggerStateChanged();
                }
            };
        }
        this.debugger.addDebuggerListener(this.debuggerListener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DebuggerChildren
    extends Children.Keys {
        private DebuggerChildren() {
        }

        protected void addNotify() {
            Object[] rns = GUIManager.getDefault().getRootNodes();
            this.setKeys(rns);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            Node n = NodesRegistry.getNode((String)key, new Object[0]);
            if (n == null) {
                return new Node[0];
            }
            return new Node[]{n};
        }
    }
}

