/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.support.DebuggerContextSettings;
import org.netbeans.modules.debugger.support.View2;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.FilterToolbar;
import org.netbeans.modules.debugger.support.nodes.PropertiesView;
import org.netbeans.modules.debugger.support.nodes.ToolbarView;
import org.netbeans.modules.debugger.support.nodes.TreeTableExplorerViewSupport;
import org.openide.actions.UndockAction;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class DebuggerWindow
extends TopComponent {
    static final long serialVersionUID = 3943837264524812348L;
    private static final int SERIAL_VERSION = 2;
    public static final String PROP_VIEWS = "views";
    public static final String PROP_ORIENTATION = "orientation";
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int ALTERNATE = 3;
    private GUIManager.View[] views = new GUIManager.View[0];
    private ToolbarListener toolbarListener;
    private FListener fListener;
    private CListener cListener;
    private HashMap viewToComponent = new HashMap();
    private HashMap viewToListeners = new HashMap();
    private ToolbarView toolbar;
    private HashSet visibleViews;
    private PropertiesView propertiesView;
    private TopComponent activatedTopComponent;
    private boolean initialized = false;
    private static DebuggerContextSettings dcSettings = null;
    private DCSettingsListener dcSettingsListener = null;
    private boolean vertical;
    private HashMap sizes = null;
    private HashMap columns = null;
    private int serSize = -1;
    private String workspace;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerContextSettings;

    public DebuggerWindow() {
        this.toolbarListener = new ToolbarListener();
        this.fListener = new FListener();
        this.cListener = new CListener();
        this.setName(DebuggerNode.getLocalizedString("CTL_Debugger_Window"));
        this.setToolTipText(DebuggerNode.getLocalizedString("CTL_Debugger_Window"));
        this.setIcon(new ImageIcon((class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow == null ? (class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow = DebuggerWindow.class$("org.netbeans.modules.debugger.support.nodes.DebuggerWindow")) : class$org$netbeans$modules$debugger$support$nodes$DebuggerWindow).getResource("/org/netbeans/modules/debugger/resources/DebugTab.gif")).getImage());
        GUIManager.getDefault().addPropertyChangeListener(new GUIManagerListener(this));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(300, 490));
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        try {
            super.writeExternal(oo);
            oo.write(2);
            if (this.initialized) {
                HashSet<GUIManager.View> visibleViews = new HashSet<GUIManager.View>();
                HashMap<GUIManager.View, Integer> sizes = new HashMap<GUIManager.View, Integer>();
                HashMap columns = new HashMap();
                boolean vertical = this.isVertical();
                int k = this.views.length;
                int i = 0;
                while (i < k) {
                    TopComponent c;
                    if (this.isVisible(this.views[i])) {
                        visibleViews.add(this.views[i]);
                    }
                    if ((c = (TopComponent)this.viewToComponent.get(this.views[i])) != null) {
                        sizes.put(this.views[i], new Integer(vertical ? c.getSize().height : c.getSize().width));
                        if (c instanceof TreeTableExplorerViewSupport) {
                            TreeTableExplorerViewSupport vs = (TreeTableExplorerViewSupport)c;
                            Node.Property[] prop = vs.getColumns();
                            int jj = prop.length;
                            HashMap props = new HashMap();
                            int j = 0;
                            while (j < jj) {
                                HashMap<String, Object> values = new HashMap<String, Object>();
                                if (prop[j].getValue("InvisibleInTreeTableView") != null) {
                                    values.put("InvisibleInTreeTableView", prop[j].getValue("InvisibleInTreeTableView"));
                                }
                                if (prop[j].getValue("SortingColumnTTV") != null) {
                                    values.put("SortingColumnTTV", prop[j].getValue("SortingColumnTTV"));
                                }
                                if (prop[j].getValue("ComparableColumnTTV") != null) {
                                    values.put("ComparableColumnTTV", prop[j].getValue("ComparableColumnTTV"));
                                }
                                if (prop[j].getValue("DescendingOrderTTV") != null) {
                                    values.put("DescendingOrderTTV", prop[j].getValue("DescendingOrderTTV"));
                                }
                                if (prop[j].getValue("TreeColumnTTV") != null) {
                                    values.put("TreeColumnTTV", prop[j].getValue("TreeColumnTTV"));
                                }
                                if (prop[j].getValue("OrderNumberTTV") != null) {
                                    values.put("OrderNumberTTV", prop[j].getValue("OrderNumberTTV"));
                                }
                                props.put(prop[j].getName(), values);
                                ++j;
                            }
                            columns.put(this.views[i], props);
                        }
                    }
                    ++i;
                }
                oo.writeObject(visibleViews);
                oo.writeObject(sizes);
                oo.writeObject(columns);
                oo.writeObject(new Integer(this.getDWSize()));
                oo.writeObject(vertical ? Boolean.TRUE : Boolean.FALSE);
                oo.writeObject(this.workspace);
            } else {
                oo.writeObject(null);
                oo.writeObject(null);
                oo.writeObject(new Integer(-1));
                oo.writeObject(Boolean.FALSE);
                oo.writeObject("Debugging");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int ver = 0;
        try {
            super.readExternal(in);
            ver = in.read();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.visibleViews = (HashSet)in.readObject();
        this.sizes = (HashMap)in.readObject();
        if (ver > 1) {
            this.columns = (HashMap)in.readObject();
        }
        this.serSize = (Integer)in.readObject();
        this.vertical = (Boolean)in.readObject();
        this.workspace = (String)in.readObject();
    }

    public void addNotify() {
        if (!this.initialized) {
            this.setViews(GUIManager.getDefault().getViews());
        }
        if (this.columns != null) {
            GUIManager.View[] vs = GUIManager.getDefault().getViews();
            int k = vs.length;
            int i = 0;
            while (i < k) {
                TopComponent tc = (TopComponent)this.viewToComponent.get(vs[i]);
                if (tc instanceof TreeTableExplorerViewSupport) {
                    TreeTableExplorerViewSupport ttv = (TreeTableExplorerViewSupport)tc;
                    HashMap props = (HashMap)this.columns.get(vs[i]);
                    Node.Property[] props2 = ttv.getColumns();
                    int jj = props2.length;
                    int j = 0;
                    while (j < jj) {
                        HashMap values = (HashMap)props.get(props2[j].getName());
                        if (values.get("InvisibleInTreeTableView") != null) {
                            props2[j].setValue("InvisibleInTreeTableView", values.get("InvisibleInTreeTableView"));
                        }
                        if (values.get("SortingColumnTTV") != null) {
                            props2[j].setValue("SortingColumnTTV", values.get("SortingColumnTTV"));
                        }
                        if (values.get("DescendingOrderTTV") != null) {
                            props2[j].setValue("DescendingOrderTTV", values.get("DescendingOrderTTV"));
                        }
                        if (values.get("ComparableColumnTTV") != null) {
                            props2[j].setValue("ComparableColumnTTV", values.get("ComparableColumnTTV"));
                        }
                        if (values.get("TreeColumnTTV") != null) {
                            props2[j].setValue("TreeColumnTTV", values.get("TreeColumnTTV"));
                        }
                        if (values.get("OrderNumberTTV") != null) {
                            props2[j].setValue("OrderNumberTTV", values.get("OrderNumberTTV"));
                        }
                        ++j;
                    }
                    ttv.setColumns(props2);
                }
                ++i;
            }
            this.columns = null;
        }
        this.initialized = true;
        this.visibleViews = null;
        this.sizes = null;
        this.serSize = -1;
        ((Component)((Object)this)).enableEvents(101L);
        if (dcSettings == null) {
            dcSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = DebuggerWindow.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        }
        this.dcSettingsListener = new DCSettingsListener();
        dcSettings.addPropertyChangeListener(this.dcSettingsListener);
        super.addNotify();
        if (this.vertical != this.isVertical()) {
            this.showViews(this.getViews());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        dcSettings.removePropertyChangeListener(this.dcSettingsListener);
        this.dcSettingsListener = null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("debug.debugger.window");
    }

    private static int getOrientation() {
        if (dcSettings == null) {
            dcSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = DebuggerWindow.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        }
        return dcSettings.getDWOrientation();
    }

    private boolean isVertical() {
        if (this.serSize != -1) {
            return this.vertical;
        }
        return DebuggerWindow.getOrientation() == 3 ? 1.5 * ((Component)((Object)this)).getSize().getHeight() >= ((Component)((Object)this)).getSize().getWidth() : DebuggerWindow.getOrientation() == 2;
    }

    public TopComponent getComponent(GUIManager.View view) {
        return (TopComponent)this.viewToComponent.get(view);
    }

    public boolean isVisible(GUIManager.View v) {
        if (this.visibleViews != null) {
            return this.visibleViews.contains(v);
        }
        if (this.toolbar != null) {
            return this.toolbar.isVisible(v);
        }
        if (v instanceof View2) {
            return ((View2)v).isVisible();
        }
        return true;
    }

    public void setVisible(GUIManager.View view, boolean visible) {
        if (this.toolbar != null) {
            this.toolbar.setVisible(view, visible);
        }
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String w) {
        if (this.workspace != null) {
            throw new SecurityException("Workspace already set!");
        }
        this.workspace = w;
    }

    public GUIManager.View[] getViews() {
        return this.views;
    }

    public void addView(int index, GUIManager.View v) {
        if (this.views.length == 0) {
            this.setViews(new GUIManager.View[]{v});
            return;
        }
        GUIManager.View[] n = new GUIManager.View[this.views.length + 1];
        if (index > 0) {
            System.arraycopy(this.views, 0, n, 0, index);
        }
        if (index < this.views.length) {
            System.arraycopy(this.views, index, n, index + 1, this.views.length - index);
        }
        n[Math.min((int)index, (int)this.views.length)] = v;
        this.setViews(n);
    }

    public boolean removeView(GUIManager.View v) {
        int k = this.views.length;
        int i = 0;
        while (i < k) {
            if (this.views[i] == v) {
                if (k == 1) {
                    this.setViews(new GUIManager.View[0]);
                } else {
                    GUIManager.View[] n = new GUIManager.View[k - 1];
                    if (i > 0) {
                        System.arraycopy(this.views, 0, n, 0, i);
                    }
                    if (i < k - 1) {
                        System.arraycopy(this.views, i + 1, n, i, k - i - 1);
                    }
                    this.setViews(n);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setViews(GUIManager.View[] vs) {
        GUIManager.View[] old = this.views;
        this.views = vs;
        if (vs.length == 0) {
            if (this.isOpened()) {
                this.setCloseOperation(0);
                this.close();
            }
        } else {
            this.showViews(this.views);
        }
        if (vs.length != 0 && !this.isOpened()) {
            this.setCloseOperation(1);
            this.open();
        }
        ((Component)((Object)this)).firePropertyChange(PROP_VIEWS, old, this.views);
    }

    private int getOldSize(GUIManager.View v, TopComponent c) {
        if (this.sizes != null) {
            Integer i = (Integer)this.sizes.get(v);
            return i == null ? 0 : i;
        }
        return this.isVertical() ? c.getSize().height : c.getSize().width;
    }

    private int getDWSize() {
        if (this.serSize != -1) {
            return this.serSize;
        }
        return this.isVertical() ? ((Component)((Object)this)).getSize().height : ((Component)((Object)this)).getSize().width;
    }

    protected void processComponentEvent(ComponentEvent e) {
        if (this.isVertical() != this.vertical) {
            this.setViews(this.views);
        }
        super.processComponentEvent(e);
    }

    private void showViews(GUIManager.View[] newViews) {
        int avgResSize;
        Object p = this;
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        ((Container)((Object)this)).removeAll();
        HashMap<GUIManager.View, TopComponent> newVtoC = new HashMap<GUIManager.View, TopComponent>();
        boolean oldVertical = this.vertical;
        this.vertical = this.isVertical();
        int resCount = 0;
        int fixSize = 0;
        int resSize = 0;
        int newResCount = 0;
        int k = newViews.length;
        boolean relToolbar = this.toolbar != null;
        int i = 0;
        while (i < k) {
            GUIManager.View v = newViews[i];
            if (this.isVisible(v)) {
                TopComponent oldC = (TopComponent)this.viewToComponent.get(v);
                TopComponent newC = v.getComponent();
                if (newC == null) {
                    if (oldC != null) {
                        this.viewToComponent.remove(v);
                    }
                } else {
                    TopComponent sizeInfoC;
                    if (oldC == null || newC.getClass() != oldC.getClass()) {
                        if (oldC != null) {
                            newC.setSize(oldC.getSize());
                        }
                        this.initSpecialViews(v, newC);
                        this.viewToComponent.put(v, newC);
                        sizeInfoC = newC;
                    } else {
                        sizeInfoC = oldC;
                    }
                    if (!(v instanceof View2) || !((View2)v).hasFixedSize()) {
                        ++resCount;
                        int size = this.getOldSize(v, sizeInfoC);
                        if (size > 0) {
                            resSize += size;
                        } else {
                            ++newResCount;
                        }
                    } else {
                        fixSize += this.vertical ? sizeInfoC.getPreferredSize().height : sizeInfoC.getPreferredSize().width;
                    }
                }
            }
            ++i;
        }
        int dwSize = this.getDWSize();
        if (resCount != 0) {
            avgResSize = (dwSize - fixSize) / resCount;
            fixSize += avgResSize * newResCount;
        } else {
            avgResSize = 0;
        }
        int currSize = 0;
        i = 0;
        while (i < k) {
            TopComponent c;
            GUIManager.View v = newViews[i];
            if (this.isVisible(v) && (c = (TopComponent)this.viewToComponent.remove(v)) != null) {
                JPanel np;
                if (!c.isVisible()) {
                    c.setVisible(true);
                }
                if (c instanceof ToolbarView) {
                    relToolbar = false;
                    ((ToolbarView)c).setOrientation(this.vertical ? 0 : 1);
                    if (this.visibleViews != null) {
                        ((Component)((Object)((ToolbarView)c))).removePropertyChangeListener(this.toolbarListener);
                        ((ToolbarView)c).setViews(this.views);
                        ((ToolbarView)c).setVisible(this.visibleViews);
                        ((Container)((Object)((ToolbarView)c))).addPropertyChangeListener(this.toolbarListener);
                    }
                }
                if (c instanceof FilterToolbar) {
                    ((FilterToolbar)c).setOrientation(this.vertical ? 0 : 1);
                }
                newVtoC.put(v, c);
                if (v instanceof View2 && ((View2)v).hasFixedSize()) {
                    ((Container)p).add((Component)c, this.vertical ? "North" : "West");
                    if (i < k - 1) {
                        np = new JPanel();
                        np.setLayout(new BorderLayout(0, 0));
                        ((Container)p).add((Component)np, "Center");
                        p = np;
                    }
                    currSize += this.getOldSize(v, c);
                } else {
                    if (resCount <= 1) {
                        ((Container)p).add((Component)c, "Center");
                        if (i < k - 1) {
                            np = new JPanel();
                            np.setLayout(new BorderLayout(0, 0));
                            ((Container)p).add((Component)np, this.vertical ? "South" : "East");
                            p = np;
                        }
                    } else {
                        int pSize;
                        np = new JPanel();
                        np.setLayout(new BorderLayout(0, 0));
                        SplittedPanel sp = new SplittedPanel();
                        sp.setSplitType(this.vertical ? 1 : 2);
                        sp.setSplitAbsolute(false);
                        sp.setSwapPanesEnabled(false);
                        sp.setSplitTypeChangeEnabled(false);
                        sp.putClientProperty("popupMenuEnabled", Boolean.FALSE);
                        int size = this.getOldSize(v, c);
                        if (dwSize < 1 || oldVertical != this.vertical) {
                            pSize = 100 / resCount;
                        } else {
                            size = size < 1 ? avgResSize : size * (dwSize - fixSize) / resSize;
                            pSize = dwSize == currSize ? size * 100 : size * 100 / (dwSize - currSize);
                            currSize += size;
                        }
                        sp.setSplitPosition(pSize);
                        sp.add((Component)c, SplittedPanel.ADD_FIRST);
                        sp.add((Component)np, SplittedPanel.ADD_SECOND);
                        ((Container)p).add((Component)sp, "Center");
                        p = np;
                    }
                    --resCount;
                }
            }
            ++i;
        }
        if (relToolbar) {
            ((Component)((Object)this.toolbar)).removePropertyChangeListener(this.toolbarListener);
            this.toolbar = null;
        }
        Iterator it = this.viewToComponent.keySet().iterator();
        while (it.hasNext()) {
            GUIManager.View v = (GUIManager.View)it.next();
            Object c = this.viewToComponent.get(v);
            if (c instanceof PropertiesView) {
                this.propertiesView = null;
                continue;
            }
            ArrayList cc = (ArrayList)this.viewToListeners.remove(v);
            if (cc == null) continue;
            int ww = cc.size();
            int w = 0;
            while (w < ww) {
                Component component = (Component)cc.get(w);
                component.removeFocusListener(this.fListener);
                component.removeComponentListener(this.cListener);
                ++w;
            }
            if (!(c instanceof ExplorerManager.Provider)) continue;
            ExplorerManager.Provider emp = (ExplorerManager.Provider)c;
            emp.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this.fListener);
        }
        this.viewToComponent = newVtoC;
        if (this.toolbar != null) {
            this.toolbar.setViews(this.views);
        }
        ((JComponent)((Object)this)).revalidate();
        ((Component)((Object)this)).repaint();
    }

    private void initSpecialViews(GUIManager.View v, TopComponent c) {
        if (c instanceof ToolbarView) {
            if (this.toolbar != null) {
                ((Component)((Object)this.toolbar)).removePropertyChangeListener(this.toolbarListener);
            }
            this.toolbar = (ToolbarView)c;
            ((Container)((Object)this.toolbar)).addPropertyChangeListener(this.toolbarListener);
        } else if (c instanceof PropertiesView) {
            this.propertiesView = (PropertiesView)c;
        } else if (c instanceof ExplorerManager.Provider) {
            ArrayList cc = new ArrayList();
            DebuggerWindow.findFocusables((Container)c, cc);
            int qq = cc.size();
            int q = 0;
            while (q < qq) {
                Component cm = (Component)cc.get(q);
                cm.addFocusListener(this.fListener);
                ++q;
            }
            this.viewToListeners.put(v, cc);
            ((ExplorerManager.Provider)c).getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this.fListener);
        }
    }

    private static void findFocusables(Container c, ArrayList l) {
        if (DebuggerWindow.isFocusTraversable(c)) {
            l.add(c);
        }
        int k = c.getComponentCount();
        Component cc = null;
        int i = 0;
        while (i < k) {
            cc = c.getComponent(i);
            if (DebuggerWindow.isFocusTraversable(cc)) {
                l.add(cc);
            }
            if (cc instanceof Container) {
                DebuggerWindow.findFocusables((Container)cc, l);
            }
            ++i;
        }
    }

    private static boolean isFocusTraversable(Component c) {
        return c.isFocusTraversable();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GUIManagerListener
    implements PropertyChangeListener {
        private WeakReference window;

        GUIManagerListener(DebuggerWindow dw) {
            this.window = new WeakReference<DebuggerWindow>(dw);
            GUIManager.getDefault().addPropertyChangeListener(this);
        }

        private DebuggerWindow getWindow() {
            DebuggerWindow dw = (DebuggerWindow)((Object)this.window.get());
            if (dw == null) {
                GUIManager.getDefault().removePropertyChangeListener(this);
            }
            return dw;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() != DebuggerWindow.PROP_VIEWS) {
                return;
            }
            DebuggerWindow dw = this.getWindow();
            if (dw == null) {
                return;
            }
            dw.setViews(GUIManager.getDefault().getViews());
        }
    }

    class UndockPerformer
    implements ActionPerformer {
        UndockPerformer() {
        }

        public void performAction(SystemAction action) {
            Iterator i = DebuggerWindow.this.viewToComponent.keySet().iterator();
            GUIManager.View v = null;
            while (i.hasNext()) {
                v = (GUIManager.View)i.next();
                if (DebuggerWindow.this.viewToComponent.get(v) == DebuggerWindow.this.activatedTopComponent) break;
            }
            if (v == null) {
                return;
            }
            DebuggerWindow.this.viewToComponent.remove(v);
            DebuggerWindow.this.setVisible(v, false);
            DebuggerWindow.this.activatedTopComponent.open();
        }
    }

    private class CListener
    extends ComponentAdapter {
        private CListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    private class FListener
    extends FocusAdapter
    implements PropertyChangeListener {
        private ExplorerActions explorerActions;
        private ExplorerManager explorerManager;
        private UndockAction undockAction = (UndockAction)SystemAction.get((Class)(class$org$openide$actions$UndockAction == null ? (class$org$openide$actions$UndockAction = FListener.class$("org.openide.actions.UndockAction")) : class$org$openide$actions$UndockAction));
        static /* synthetic */ Class class$org$openide$actions$UndockAction;

        FListener() {
        }

        public void focusGained(FocusEvent e) {
            Component component;
            Component c = component = (Component)e.getSource();
            while (!(c instanceof ExplorerManager.Provider)) {
                c = c.getParent();
            }
            ExplorerManager em = ((ExplorerManager.Provider)c).getExplorerManager();
            this.setContext(em);
            if (this.explorerActions == null) {
                this.explorerActions = new ExplorerActions();
            }
            if (this.explorerManager != null) {
                this.explorerActions.detach();
            }
            this.explorerManager = em;
            this.explorerActions.attach(this.explorerManager);
            this.explorerActions.setConfirmDelete(false);
            while (!(c instanceof TopComponent)) {
                c = c.getParent();
            }
            DebuggerWindow.this.activatedTopComponent = (TopComponent)c;
            ((JComponent)((Object)DebuggerWindow.this)).putClientProperty("InnerComponent", DebuggerWindow.this.activatedTopComponent);
            this.undockAction.setActionPerformer((ActionPerformer)new UndockPerformer());
        }

        public void focusLost(FocusEvent e) {
        }

        public void propertyChange(PropertyChangeEvent e) {
            ExplorerManager em = (ExplorerManager)e.getSource();
            if (em != this.explorerManager) {
                return;
            }
            this.setContext(em);
        }

        private void setContext(ExplorerManager em) {
            Node[] ns = em.getSelectedNodes();
            DebuggerWindow.this.setActivatedNodes(ns);
            if (DebuggerWindow.this.propertiesView != null) {
                DebuggerWindow.this.propertiesView.getPropertySheet().setNodes(ns);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ToolbarListener
    implements PropertyChangeListener {
        private ToolbarListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null || e.getPropertyName() != "visible") {
                return;
            }
            DebuggerWindow.this.showViews(DebuggerWindow.this.getViews());
            DebuggerWindow.super.firePropertyChange(DebuggerWindow.PROP_VIEWS, null, null);
        }
    }

    private class DCSettingsListener
    implements PropertyChangeListener {
        private DCSettingsListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null || e.getPropertyName() != "dwOrientation") {
                return;
            }
            DebuggerWindow.this.showViews(DebuggerWindow.this.getViews());
        }
    }
}

