/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.nodes.ThreadNode;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class LocalsRootNode
extends AbstractNode
implements ThreadNode.Refreshable {
    static final long serialVersionUID = -6346315017458451778L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/Locals";
    private AbstractThread thread;
    private LocalsListener localsListener;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode = LocalsRootNode.class$("org.netbeans.modules.debugger.support.nodes.LocalsRootNode")) : class$org$netbeans$modules$debugger$support$nodes$LocalsRootNode), (String)s);
    }

    public LocalsRootNode(AbstractThread thread, AbstractDebugger debugger) {
        super((Children)new LocalsRootChildren());
        this.thread = thread;
        String s = LocalsRootNode.getLocalizedString("CTL_Locals");
        this.setDisplayName(s);
        this.setName(s);
        this.setIconBase(ICON_BASE);
        this.localsListener = new LocalsListener(this);
        thread.addPropertyChangeListener(this.localsListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLocalsRootNode");
    }

    public void refresh() {
        String info = ((VariablesProducer)((Object)this.thread)).getInfo();
        info = info != null ? LocalsRootNode.getLocalizedString("CTL_Locals") + " (" + info + ')' : LocalsRootNode.getLocalizedString("CTL_Locals");
        this.setDisplayName(info);
        this.setName(info);
        ((LocalsRootChildren)this.getChildren()).changeChildren();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalsListener
    implements PropertyChangeListener {
        private WeakReference node;
        private AbstractThread thread;

        LocalsListener(LocalsRootNode n) {
            this.node = new WeakReference<LocalsRootNode>(n);
            this.thread = n.thread;
        }

        public void propertyChange(PropertyChangeEvent e) {
            LocalsRootNode csn = (LocalsRootNode)this.node.get();
            if (csn == null) {
                this.thread.removePropertyChangeListener(this);
                return;
            }
            if (e.getPropertyName() != null && e.getPropertyName().equals("variables")) {
                ((LocalsRootChildren)csn.getChildren()).changeChildren();
            }
        }
    }

    private static final class LocalsRootChildren
    extends Children.Keys
    implements LeafRefresher {
        private boolean init = false;

        private LocalsRootChildren() {
        }

        protected void addNotify() {
            this.init = true;
            this.changeChildren();
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            Node node = DebuggerNode.createNode(key, new Object[]{key, new Integer(1), Boolean.TRUE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void changeChildren() {
            if (!this.init) {
                return;
            }
            AbstractThread thread = ((LocalsRootNode)this.getNode()).thread;
            if (thread instanceof CallStackProducer) {
                Location[] callStack = ((CallStackProducer)((Object)thread)).getCallStackFilter().filterCallStack((CallStackProducer)((Object)thread));
                if (callStack.length > 0) {
                    Object[] locals = ((VariablesProducer)((Object)callStack[0])).getVariablesFilter().getVariables((VariablesProducer)((Object)callStack[0]));
                    Arrays.sort(locals, Utils.localsComparator);
                    this.setKeys(locals);
                } else {
                    this.setKeys(new AbstractVariable[0]);
                }
            }
        }

        public void refreshMyKey(Object key) {
            this.refreshKey(key);
        }
    }
}

