/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public final class SessionThreadRootNode
extends AbstractNode {
    static final long serialVersionUID = -4736310787523747464L;
    private static final String THREAD_GROUP_ICON_BASE = "org/netbeans/modules/debugger/resources/allInOneView/AllInOne";

    public SessionThreadRootNode() {
        this(false);
    }

    public SessionThreadRootNode(boolean isInTree) {
        super((Children)new SessionRootChildren());
        String name = null;
        if (isInTree) {
            name = DebuggerNode.getLocalizedString("PROP_allinone_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_allinone_column_name"));
        } else {
            name = DebuggerNode.getLocalizedString("CTL_All_in_one_view");
        }
        this.setDisplayName(name);
        this.setName("SessionThreadRootNode");
        this.setIconBase(THREAD_GROUP_ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerAllInOneRootNode");
    }

    public Node.Handle getHandle() {
        return new SessionsHandle();
    }

    private static class SessionsHandle
    implements Node.Handle {
        static final long serialVersionUID = -4935665488987259653L;

        private SessionsHandle() {
        }

        public Node getNode() {
            return new SessionThreadRootNode();
        }
    }

    private static final class SessionRootChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private CoreDebugger coreDebugger;
        private AbstractDebugger[] debuggers;

        private SessionRootChildren() {
        }

        protected Node[] createNodes(Object key) {
            ThreadsProducer tp = null;
            if (key instanceof ThreadsRoot) {
                tp = ((ThreadsRoot)key).getThreadsRoot();
            }
            Node n = null;
            if (tp != null) {
                n = DebuggerNode.createNode(tp, new Object[]{tp, key});
            }
            if (n == null) {
                return new Node[0];
            }
            return new Node[]{n};
        }

        protected void addNotify() {
            this.coreDebugger = Register.getCoreDebugger();
            this.coreDebugger.addPropertyChangeListener(this);
            this.update();
        }

        protected void removeNotify() {
            this.coreDebugger.removePropertyChangeListener(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null) {
                return;
            }
            if (!e.getPropertyName().equals("debuggers")) {
                return;
            }
            this.update();
        }

        private void update() {
            Object[] ds = this.coreDebugger.getDebuggers();
            this.setKeys(ds);
        }
    }
}

