/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class ThreadNode
extends AbstractNode
implements SwitchOnCookie,
GoToSourceCookie {
    static final long serialVersionUID = 2202990736781011814L;
    public static final String PROP_THREAD_NAME = "threadName";
    public static final String PROP_THREAD_STATE = "threadState";
    public static final String PROP_THREAD_CLASS = "threadClass";
    public static final String PROP_THREAD_METHOD = "threadMethod";
    public static final String PROP_THREAD_LINE = "threadLine";
    public static final String PROP_THREAD_STACK_DEPTH = "threadStackDepth";
    public static final String PROP_THREAD_FRAME_INDEX = "threadFrameIndex";
    public static final String PROP_THREAD_SUSPENDED = "threadSuspended";
    public static final int STATE_MAIN = 1;
    public static final int STATE_STOPPED = 2;
    protected static String ICON_CURRENT = "org/netbeans/modules/coreDebugger/resources/threadsView/CurrentThread";
    protected static String ICON_RUNNING = "org/netbeans/modules/coreDebugger/resources/threadsView/Thread";
    protected static Image threadFolderIcon;
    protected static Image threadFolderIcon32;
    protected static Image threadCurrentIcon;
    protected static Image threadCurrentIcon32;
    protected static Image threadRunningIcon;
    protected static Image threadRunningIcon32;
    private static SystemAction[] staticActions;
    private CoreDebugger coreDebugger;
    private AbstractDebugger debugger;
    private final AbstractThread thread;
    private ThreadListener threadListener;
    private int state = 4;
    private boolean oldSuspended = false;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$ThreadNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchOnAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToSourceAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$ThreadNode == null ? (class$org$netbeans$modules$debugger$support$nodes$ThreadNode = ThreadNode.class$("org.netbeans.modules.debugger.support.nodes.ThreadNode")) : class$org$netbeans$modules$debugger$support$nodes$ThreadNode), (String)s);
    }

    public ThreadNode(AbstractThread thread, AbstractDebugger debugger) {
        this(thread, debugger, true);
    }

    public ThreadNode(AbstractThread thread, AbstractDebugger debugger, boolean showSubNodes) {
        super((Children)(showSubNodes ? new ThreadChildren() : Children.LEAF));
        this.thread = thread;
        this.debugger = debugger;
        this.coreDebugger = Register.getCoreDebugger();
        this.setName();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.threadListener = new ThreadListener(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadNode");
    }

    private void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set props = sheet.get("properties");
        props.setValue("helpID", "NetbeansDebuggerThreadsPropertiesSheet");
        props.put(Utils.createProperty(this.thread, class$java$lang$String == null ? (class$java$lang$String = ThreadNode.class$("java.lang.String")) : class$java$lang$String, PROP_THREAD_NAME, ThreadNode.getLocalizedString("PROP_thread_name"), ThreadNode.getLocalizedString("HINT_thread_name"), "getName", null));
        if (this.thread instanceof Location) {
            props.put(Utils.createProperty(this, Integer.TYPE, PROP_THREAD_LINE, ThreadNode.getLocalizedString("PROP_thread_line"), ThreadNode.getLocalizedString("HINT_thread_line"), "getLineNumber", null));
        }
        if (this.thread instanceof CallStackProducer) {
            props.put(Utils.createProperty(this, Integer.TYPE, PROP_THREAD_STACK_DEPTH, ThreadNode.getLocalizedString("PROP_thread_stack_depth"), ThreadNode.getLocalizedString("HINT_thread_stack_depth"), "getStackDepth", null));
        }
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = ThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction)), SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToSourceAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToSourceAction = ThreadNode.class$("org.netbeans.modules.debugger.support.actions.GoToSourceAction")) : class$org$netbeans$modules$debugger$support$actions$GoToSourceAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ThreadNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ThreadNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = ThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction));
    }

    public void destroy() throws IOException {
        super.destroy();
        this.coreDebugger.removePropertyChangeListener(this.threadListener);
        this.thread.removePropertyChangeListener(this.threadListener);
    }

    public boolean canSetCurrent() {
        return !this.thread.isCurrent();
    }

    public void setCurrent() {
        this.thread.setCurrent(true);
        this.coreDebugger.setCurrentDebugger(this.debugger);
    }

    public void goToSource() {
        Line l = ((Location)((Object)this.thread)).getLine();
        if (l != null) {
            l.show(2);
        }
    }

    public boolean canGoToSource() {
        Line l = ((Location)((Object)this.thread)).getLine();
        return l != null;
    }

    public int getLineNumber() {
        if (!(this.thread instanceof Location) || ((Location)((Object)this.thread)).getLine() == null) {
            return -1;
        }
        return ((Location)((Object)this.thread)).getLine().getLineNumber();
    }

    public int getStackDepth() {
        if (!(this.thread instanceof CallStackProducer)) {
            return -1;
        }
        return ((CallStackProducer)((Object)this.thread)).getCallStack().length;
    }

    void refreshIcon() {
        if ((this.state & 1) != 0) {
            this.setIconBase(ICON_CURRENT);
        } else {
            this.setIconBase(ICON_RUNNING);
        }
    }

    public final boolean equals(Object o) {
        return o instanceof ThreadNode && ((ThreadNode)o).thread.equals(this.thread);
    }

    public final int hashCode() {
        return this.thread.hashCode();
    }

    void changeProperties() {
        this.setName();
        this.firePropertyChange(null, null, null);
    }

    void setName() {
        int newS = 0;
        if (this.thread.isCurrent() && this.coreDebugger.getCurrentDebugger() == this.debugger) {
            newS = 1;
        }
        if (this.state != newS) {
            this.state = newS;
            this.refreshIcon();
        }
        String s = this.thread.getName();
        this.setDisplayName(s);
        this.setName(s);
    }

    AbstractThread getDebuggerThread() {
        return this.thread;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ThreadListener
    implements PropertyChangeListener {
        private WeakReference node;
        private CoreDebugger coreDebugger;
        private AbstractThread thread;

        ThreadListener(ThreadNode n) {
            this.node = new WeakReference<ThreadNode>(n);
            this.coreDebugger = n.coreDebugger;
            this.thread = n.thread;
            this.thread.addPropertyChangeListener(this);
            this.coreDebugger.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            ThreadNode tn = (ThreadNode)this.node.get();
            if (tn == null) {
                this.coreDebugger.removePropertyChangeListener(this);
                this.thread.removePropertyChangeListener(this);
                return;
            }
            if (e.getSource() == this.coreDebugger && e.getPropertyName() != "currentDebugger") {
                return;
            }
            tn.changeProperties();
            ((ThreadChildren)tn.getChildren()).refreshAll();
        }
    }

    public static interface Refreshable {
        public void refresh();
    }

    private static final class ThreadChildren
    extends Children.Keys {
        private boolean initialized = false;

        private ThreadChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            AbstractThread thread = ((ThreadNode)this.getNode()).thread;
            LinkedList<String> l = new LinkedList<String>();
            if (thread instanceof VariablesProducer) {
                l.add("localsNode");
            }
            if (thread instanceof CallStackProducer) {
                l.add("callStackNode");
            }
            this.setKeys(l);
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            AbstractThread thread = ((ThreadNode)this.getNode()).thread;
            Node node = NodesRegistry.getNode(key, new Object[]{thread});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void refreshAll() {
            if (!this.initialized) {
                return;
            }
            Node[] ns = this.getNodes();
            int k = ns.length;
            int i = 0;
            while (i < k) {
                if (ns[i] instanceof Refreshable) {
                    ((Refreshable)ns[i]).refresh();
                }
                ++i;
            }
        }
    }
}

