/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadListener;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ThreadsRootNode
extends AbstractNode {
    static final long serialVersionUID = -8123352660663524178L;
    private static String ICON_BASE = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode = ThreadsRootNode.class$("org.netbeans.modules.debugger.support.nodes.ThreadsRootNode")) : class$org$netbeans$modules$debugger$support$nodes$ThreadsRootNode), (String)s);
    }

    public ThreadsRootNode() {
        this(false);
    }

    public ThreadsRootNode(boolean isInTree) {
        super((Children)new CallStackChildren());
        String name = null;
        if (isInTree) {
            name = DebuggerNode.getLocalizedString("PROP_threads_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_threads_column_name"));
        } else {
            name = ThreadsRootNode.getLocalizedString("CTL_ThreadRootNode");
        }
        this.setDisplayName(name);
        this.setName("ThreadsRootNode");
        this.setIconBase(ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerThreadsRootNode");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallStackListener
    implements PropertyChangeListener,
    ThreadListener {
        private WeakReference ch;
        private CoreDebugger debugger;
        private ThreadsProducer threadsProducer;

        CallStackListener(CallStackChildren ch) {
            this.ch = new WeakReference<CallStackChildren>(ch);
            this.debugger = ch.debugger;
            this.debugger.addPropertyChangeListener(this);
            this.refreshAll(ch);
        }

        private CallStackChildren getCh() {
            CallStackChildren chi = (CallStackChildren)((Object)this.ch.get());
            if (chi == null) {
                this.destroy();
                return null;
            }
            return chi;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.threadsProducer != null) {
                this.threadsProducer.removeThreadListener(this);
            }
            this.debugger = null;
            this.threadsProducer = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            CallStackChildren ch = this.getCh();
            if (ch == null) {
                return;
            }
            if (e.getPropertyName() != null && e.getPropertyName().equals("currentDebugger")) {
                this.refreshAll(ch);
            }
        }

        public void threadCreated(AbstractThread thread) {
            CallStackChildren ch = this.getCh();
            if (ch == null) {
                return;
            }
            ch.refreshKeys(this.threadsProducer.getThreads());
        }

        public void threadDeath(AbstractThread thread) {
            CallStackChildren ch = this.getCh();
            if (ch == null) {
                return;
            }
            ch.refreshKeys(this.threadsProducer.getThreads());
        }

        void refreshAll(CallStackChildren ch) {
            AbstractDebugger d = this.debugger.getCurrentDebugger();
            if (d != null && d instanceof ThreadsRoot) {
                ThreadsProducer tp = ((ThreadsRoot)((Object)d)).getThreadsRoot();
                if (tp != this.threadsProducer || !tp.equals(this.threadsProducer)) {
                    if (this.threadsProducer != null) {
                        this.threadsProducer.removeThreadListener(this);
                    }
                    tp.addThreadListener(this);
                    this.threadsProducer = tp;
                }
                ch.refreshKeys(this.threadsProducer.getThreads());
            } else {
                if (this.threadsProducer != null) {
                    this.threadsProducer.removeThreadListener(this);
                }
                this.threadsProducer = null;
                ch.refreshKeys(new Object[0]);
            }
        }
    }

    private static final class CallStackChildren
    extends Children.Keys {
        private boolean init = false;
        private ArrayList keys = new ArrayList();
        private CoreDebugger debugger;

        private CallStackChildren() {
        }

        protected void addNotify() {
            this.init = true;
            this.debugger = Register.getCoreDebugger();
            new CallStackListener(this);
        }

        protected void removeNotify() {
            this.init = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object thread) {
            Node node = DebuggerNode.createNode(thread, new Object[]{thread, this.debugger.getCurrentDebugger(), Boolean.FALSE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        protected void destroyNodes(Node[] ns) {
            try {
                int k = ns.length;
                int i = 0;
                while (i < k) {
                    ns[i].destroy();
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void refreshKeys(Object[] o) {
            if (!this.init) {
                return;
            }
            this.setKeys(o);
        }
    }
}

