/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.nodes.WatchDelegate;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class VariableNode
extends AbstractNode {
    static final long serialVersionUID = -4167730461290769518L;
    protected static String ICON_BASE = "org/netbeans/modules/debugger/resources/watchesView/Variable";
    protected static String ICON_STATIC_VARIABLE = "org/netbeans/modules/debugger/resources/watchesView/StaticVariable";
    public static final String PROP_MODIFIERS = "modifiers";
    public static final String PROP_INNER_TYPE = "innerType";
    public static final String PROP_BASE_INDEX = "baseIndex";
    public static final String PROP_DISPLAYED_LENGTH = "displayedLength";
    public static final int TYPE_VARIABLE = 0;
    public static final int TYPE_LOCAL_VARIABLE = 1;
    public static final int TYPE_FIXED_VARIABLE = 2;
    protected int type;
    protected AbstractVariable variable = null;
    protected transient CoreDebugger debugger;
    private PropertyChangeListener pcl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$VariableNode;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public VariableNode(AbstractVariable variable, int type) {
        super((Children)(variable instanceof VariablesProducer ? (((VariablesProducer)((Object)variable)).isLeaf() ? Children.LEAF : new VariableContextChildren()) : Children.LEAF));
        this.type = type;
        this.variable = variable;
        this.init();
    }

    public VariableNode(AbstractVariable variable) {
        this(variable, 0);
    }

    protected void init() {
        this.variable.addPropertyChangeListener(new VariableListener(this));
        this.setDisplayName(this.getName());
        this.setName(this.getName());
        this.setIconBase(ICON_BASE);
        this.debugger = Register.getCoreDebugger();
        this.createProperties();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerVariableNode");
    }

    private void readObject(ObjectInputStream obis) throws IOException, ClassNotFoundException, NotActiveException {
        obis.defaultReadObject();
        this.init();
    }

    public String getVariableValue() {
        return this.variable.getAsText();
    }

    public void setVariableValue(String value) {
        try {
            this.variable.setAsText(value);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    protected void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.setValue("helpID", "NetbeansDebuggerLocalsPropertiesSheet");
        ps.put(Utils.createProperty(this.variable, class$java$lang$String == null ? (class$java$lang$String = VariableNode.class$("java.lang.String")) : class$java$lang$String, "variableName", NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"PROP_watch_name"), NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"HINT_watch_name"), "getVariableName", null));
        ps.put(Utils.createProperty(this.variable, class$java$lang$String == null ? (class$java$lang$String = VariableNode.class$("java.lang.String")) : class$java$lang$String, "type", NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"PROP_watch_type"), NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"HINT_watch_type"), "getType", null));
        ps.put(Utils.createProperty((Object)this, class$java$lang$String == null ? (class$java$lang$String = VariableNode.class$("java.lang.String")) : class$java$lang$String, "asText", NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"PROP_watch_value"), NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"HINT_watch_value"), "getVariableValue", this.type == 2 ? null : "setVariableValue"));
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        if (this.type == 2) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = VariableNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = VariableNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = VariableNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = VariableNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = VariableNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public boolean canDestroy() {
        return this.type == 2;
    }

    public void destroy() throws IOException {
        if (this.variable == null) {
            return;
        }
        this.variable.removePropertyChangeListener(this.pcl);
        if (this.getChildren() == Children.LEAF) {
            return;
        }
        VariableContextChildren myChildren = (VariableContextChildren)this.getChildren();
        if (!myChildren.initialized) {
            return;
        }
        Node[] n = myChildren.getNodes();
        int k = n.length;
        int i = 0;
        while (i < k) {
            ((VariableNode)n[i]).destroy();
            ++i;
        }
        super.destroy();
    }

    public AbstractVariable getVariable() {
        return this.variable;
    }

    public String getName() {
        String name = this.variable.getVariableName();
        if (name == null || this.debugger == null) {
            return "???";
        }
        AbstractDebugger d = this.debugger.getCurrentDebugger();
        if (d == null || d.getState() == 1) {
            return name + " " + NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"CTL_NoSession");
        }
        String type = this.variable.getType();
        String value = this.variable.getAsText();
        if (value == null) {
            return name + " " + NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$VariableNode == null ? (class$org$netbeans$modules$debugger$support$nodes$VariableNode = VariableNode.class$("org.netbeans.modules.debugger.support.nodes.VariableNode")) : class$org$netbeans$modules$debugger$support$nodes$VariableNode), (String)"CTL_NotInitialized");
        }
        if (type == null) {
            return name + " = " + value;
        }
        return name + " = (" + type + ") " + value;
    }

    protected void parameterChanged(PropertyChangeEvent e) {
        String s = this.getName();
        this.setDisplayName(s);
        this.setName(s);
        this.changeChildren();
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    protected void changeChildren() {
        AbstractVariable var;
        if (this.getChildren() == Children.LEAF) {
            Node n = this.getParentNode();
            if (n == null) {
                return;
            }
            AbstractVariable v = this.getVariable();
            if (!((VariablesProducer)((Object)v)).isLeaf()) {
                LeafRefresher parentChildren = (LeafRefresher)n.getChildren();
                parentChildren.refreshMyKey(v);
            }
            return;
        }
        VariableContextChildren myChildren = (VariableContextChildren)this.getChildren();
        if (!myChildren.initialized) {
            return;
        }
        AbstractVariable abstractVariable = var = this.variable instanceof WatchDelegate ? (AbstractVariable)((WatchDelegate)((Object)this.variable)).getInnerWatch() : this.variable;
        if (var == null) {
            myChildren.setMyKeys(new AbstractVariable[0]);
            return;
        }
        VariablesFilter filter = ((VariablesProducer)((Object)var)).getVariablesFilter();
        Object[] fields = filter.getVariables((VariablesProducer)((Object)var));
        myChildren.setMyKeys(fields);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VariableListener
    implements PropertyChangeListener {
        private WeakReference node;
        private AbstractVariable variable;

        VariableListener(VariableNode n) {
            this.node = new WeakReference<VariableNode>(n);
            this.variable = n.variable;
        }

        public void propertyChange(PropertyChangeEvent e) {
            VariableNode csn = (VariableNode)((Object)this.node.get());
            if (csn == null) {
                this.variable.removePropertyChangeListener(this);
                return;
            }
            csn.parameterChanged(e);
        }
    }

    private static final class VariableContextChildren
    extends Children.Keys
    implements LeafRefresher {
        private boolean initialized = false;

        private VariableContextChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            ((VariableNode)this.getNode()).changeChildren();
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            Node node = DebuggerNode.createNode(key);
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        private void setMyKeys(Object[] keys) {
            this.setKeys(keys);
        }

        public void refreshMyKey(Object key) {
            this.refreshKey(key);
        }
    }
}

