/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.delegator.DelegatingWatch;
import org.netbeans.modules.debugger.support.actions.DeleteAllCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.openide.debugger.Debugger;
import org.openide.debugger.Watch;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class WatchesRootNode
extends AbstractNode
implements DeleteAllCookie {
    static final long serialVersionUID = -3518528079657369038L;
    private static final String ICON_WATCHES = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private static final String ICON_PENDING_WATCHES = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private static SystemAction[] staticActions;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddWatchAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$DeleteAllAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode == null ? (class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode = WatchesRootNode.class$("org.netbeans.modules.debugger.support.nodes.WatchesRootNode")) : class$org$netbeans$modules$debugger$support$nodes$WatchesRootNode), (String)s);
    }

    public WatchesRootNode() {
        this(false);
    }

    public WatchesRootNode(boolean isInTree) {
        super((Children)new WatchesRootChildren());
        String name = null;
        if (isInTree) {
            name = DebuggerNode.getLocalizedString("PROP_watches_column_name");
            this.setShortDescription(DebuggerNode.getLocalizedString("HINT_watches_column_name"));
        } else {
            name = WatchesRootNode.getLocalizedString("CTL_Watches_group_root");
        }
        this.setDisplayName(name);
        this.setName("WatchesRootNode");
        this.setIconBase("org/netbeans/modules/debugger/resources/watchesView/Watch");
        this.getCookieSet().add((Node.Cookie)this);
        this.init();
    }

    private void init() {
    }

    private void readObject(ObjectInputStream obis) throws IOException, ClassNotFoundException, NotActiveException {
        obis.defaultReadObject();
        this.init();
    }

    public Node.Handle getHandle() {
        return new WatchesHandle();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerWatchesRootNode");
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddWatchAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddWatchAction = WatchesRootNode.class$("org.netbeans.modules.debugger.support.actions.AddWatchAction")) : class$org$netbeans$modules$debugger$support$actions$AddWatchAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$DeleteAllAction == null ? (class$org$netbeans$modules$debugger$support$actions$DeleteAllAction = WatchesRootNode.class$("org.netbeans.modules.debugger.support.actions.DeleteAllAction")) : class$org$netbeans$modules$debugger$support$actions$DeleteAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = WatchesRootNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = WatchesRootNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return staticActions;
    }

    public SystemAction[] getContextActions() {
        return this.getActions();
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddWatchAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddWatchAction = WatchesRootNode.class$("org.netbeans.modules.debugger.support.actions.AddWatchAction")) : class$org$netbeans$modules$debugger$support$actions$AddWatchAction));
    }

    public void deleteAll() {
        CoreDebugger debugger = Register.getCoreDebugger();
        debugger.removeAllWatches();
        WatchesRootChildren children = (WatchesRootChildren)this.getChildren();
        children.removeAllVariables();
    }

    public void createVariable(AbstractVariable variable) {
        ((WatchesRootChildren)this.getChildren()).addVariable(variable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WatchesHandle
    implements Node.Handle {
        static final long serialVersionUID = -4518262478987259653L;

        private WatchesHandle() {
        }

        public Node getNode() {
            return new WatchesRootNode();
        }
    }

    static class DelegatingNode
    extends FilterNode {
        DelegatingWatch dw;

        private DelegatingNode(Node n, DelegatingWatch dw) {
            super(n);
            this.dw = dw;
        }

        public void destroy() {
            this.dw.remove();
        }
    }

    static class WRListener
    implements PropertyChangeListener {
        private Debugger debugger;
        private WeakReference node;
        private Watch[] watches = new Watch[0];

        WRListener(WatchesRootNode node, Debugger debugger) {
            this.debugger = debugger;
            this.node = new WeakReference<WatchesRootNode>(node);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            if (debugger instanceof ValidatorHolder) {
                Validator validator = ((ValidatorHolder)debugger).getValidator();
                validator.addPropertyChangeListener(this);
            }
            this.setWatches(node);
        }

        WatchesRootNode getNode() {
            WatchesRootNode wrn = (WatchesRootNode)this.node.get();
            if (wrn != null) {
                return wrn;
            }
            this.destroy();
            return null;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.debugger instanceof ValidatorHolder) {
                Validator validator = ((ValidatorHolder)this.debugger).getValidator();
                validator.removePropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            WatchesRootNode node = this.getNode();
            if (node == null) {
                return;
            }
            if (e.getSource() instanceof Validator) {
                node.setIconBase(((Validator)e.getSource()).isValidated() ? "org/netbeans/modules/debugger/resources/watchesView/Watch" : "org/netbeans/modules/debugger/resources/watchesView/Watch");
                return;
            }
            if (e.getPropertyName() == null) {
                return;
            }
            if (e.getPropertyName().equals("state")) {
                if (this.debugger.getState() == 1) {
                    ((WatchesRootChildren)node.getChildren()).removeAllVariables();
                }
            }
            if (e.getPropertyName().equals("watches")) {
                this.setWatches(node);
            } else if (e.getPropertyName().equals("innerWatch")) {
                this.refreshWatches(node, (Watch)e.getSource());
            }
        }

        void refreshWatches(WatchesRootNode node, Watch w) {
            ((WatchesRootChildren)node.getChildren()).refreshHelper(w);
        }

        synchronized void setWatches(WatchesRootNode node) {
            int k = this.watches.length;
            int i = 0;
            while (i < k) {
                this.watches[i].removePropertyChangeListener((PropertyChangeListener)this);
                ++i;
            }
            this.watches = this.debugger.getWatches();
            ((WatchesRootChildren)node.getChildren()).set(this.watches);
            k = this.watches.length;
            i = 0;
            while (i < k) {
                this.watches[i].addPropertyChangeListener((PropertyChangeListener)this);
                ++i;
            }
        }
    }

    static final class WatchesRootChildren
    extends Children.Keys {
        private ArrayList variables = new ArrayList();
        private WRListener l;

        WatchesRootChildren() {
        }

        protected Node[] createNodes(Object key) {
            Node node;
            Watch w;
            if (key instanceof Watch && ((Watch)key).isHidden()) {
                return new Node[0];
            }
            if (key instanceof DelegatingWatch && (w = ((DelegatingWatch)key).getInnerWatch()) != null && (node = DebuggerNode.createNode(w)) != null) {
                return new Node[]{new DelegatingNode(node, (DelegatingWatch)key)};
            }
            Node node2 = null;
            node2 = !(key instanceof Watch) ? DebuggerNode.createNode(key, new Object[]{new Integer(2)}) : DebuggerNode.createNode(key);
            if (node2 == null) {
                return new Node[0];
            }
            return new Node[]{node2};
        }

        protected void addNotify() {
            CoreDebugger debugger = Register.getCoreDebugger();
            this.l = new WRListener((WatchesRootNode)this.getNode(), debugger);
        }

        protected void removeNotify() {
            this.l.destroy();
            this.l = null;
            this.setKeys(Collections.EMPTY_SET);
        }

        void addVariable(AbstractVariable v) {
            Node n = DebuggerNode.createNode(v, new Object[]{v, new Integer(2)});
            if (n != null) {
                this.variables.add(n);
                this.add(new Node[]{n});
            }
        }

        void refreshHelper(Watch w) {
            this.refreshKey(w);
        }

        void set(Object[] ws) {
            try {
                this.setKeys(ws);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void removeAllVariables() {
            if (this.variables.size() < 1) {
                return;
            }
            Node[] nn = new Node[this.variables.size()];
            nn = this.variables.toArray(nn);
            this.remove(nn);
        }
    }
}

