/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.support.util.HistoryEvent;
import org.netbeans.modules.debugger.support.util.HistoryListener;

public abstract class AbstractHistory {
    protected transient List listenerList;

    public abstract void addItem(Object var1);

    public abstract List getItems();

    public abstract int getSize();

    public abstract boolean isEmpty();

    public abstract int getMaxSize();

    public void addHistoryListener(HistoryListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(3);
        }
        this.listenerList.add(listener);
    }

    public void removeHistoryListener(HistoryListener listener) {
        if (this.listenerList.remove(listener) && this.listenerList.isEmpty()) {
            this.listenerList = null;
        }
    }

    protected void fireAdded(Object item) {
        this.fireHistoryChanged(this, 0, null, item);
    }

    protected void fireShifted(Object lostItem, Object addedItem) {
        this.fireHistoryChanged(this, 1, lostItem, addedItem);
    }

    protected void fireChanged() {
        this.fireHistoryChanged(this, 2, null, null);
    }

    protected void fireHistoryChanged(Object source, int type, Object lost, Object added) {
        if (this.listenerList != null) {
            HistoryEvent e = new HistoryEvent(this, type, lost, added);
            Iterator i = this.listenerList.iterator();
            while (i.hasNext()) {
                ((HistoryListener)i.next()).historyListChanged(e);
            }
        }
    }
}

