/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.text.Line;

public class LinkEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor {
    private boolean active = false;

    public void setValue(Object o) {
        String s = (String)o;
        this.active = false;
        if (s != null) {
            this.active = LinkEditor.getLine(s) != null;
        }
        super.setValue(o);
    }

    public Component getInPlaceCustomEditor() {
        if (this.isActive()) {
            this.activate();
        }
        JComponent l = new JComponent(){

            protected void paintComponent(Graphics g) {
                Rectangle r = g.getClipRect();
                r.x += 4;
                LinkEditor.this.paintValue(g, r);
            }
        };
        return l;
    }

    public boolean hasInPlaceCustomEditor() {
        return true;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
        Font f = g.getFont();
        Color c = g.getColor();
        FontMetrics fm = g.getFontMetrics(g.getFont());
        if (this.isActive()) {
            g.setColor(Color.blue);
        }
        String s = (String)this.getValue();
        String e = "";
        int i = s.lastIndexOf(":");
        if (i > 0) {
            e = s.substring(i);
            s = s.substring(0, i);
        }
        if (s.endsWith(".java")) {
            s = s.substring(0, s.length() - 5);
        }
        if ((i = s.lastIndexOf(46)) > 0) {
            s = s.substring(i + 1);
        }
        s = s + e;
        g.drawString(s, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
        if (this.isActive()) {
            g.drawLine(rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent() + 1, rectangle.x + fm.stringWidth(s), rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent() + 1);
        }
        g.setColor(c);
        g.setFont(f);
    }

    public boolean supportsEditingTaggedValues() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void activate() {
        String s = (String)this.getValue();
        Line l = LinkEditor.getLine(s);
        if (l == null) {
            return;
        }
        l.show(2);
    }

    private static Line getLine(String s) {
        int ln = 1;
        int i = s.lastIndexOf(":");
        if (i > 0) {
            try {
                ln = Integer.parseInt(s.substring(i + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            s = s.substring(0, i);
        }
        if (s.endsWith(".java")) {
            s = s.substring(0, s.length() - 5);
        }
        return JUtils.getLine(s, ln);
    }

    private static String getClassName(String s) {
        int ln = 1;
        int i = s.lastIndexOf(":");
        if (i > 0) {
            try {
                ln = Integer.parseInt(s.substring(i + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            s = s.substring(0, i);
        }
        if (s.endsWith(".java")) {
            s = s.substring(0, s.length() - 5);
        }
        return s;
    }
}

