/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class PropertyChangeListeners {
    protected List listeners;
    protected Object officialEventSource;

    public PropertyChangeListeners(Object officialEventSource) {
        this.officialEventSource = officialEventSource;
    }

    public PropertyChangeListeners(Object officialEventSource, PropertyChangeListener initialListener) {
        this(officialEventSource);
        this.addPropertyChangeListener(initialListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(3);
        }
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners != null && this.listeners.remove(l) && this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public boolean hasListeners() {
        return this.listeners != null;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.officialEventSource, propertyName, oldValue, newValue);
            int size = this.listeners.size();
            int i = 0;
            while (i < size) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
                ++i;
            }
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.listeners != null) {
            this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
        }
    }
}

