/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import org.netbeans.modules.debugger.support.util.RequestSynchronizer;
import org.openide.util.RequestProcessor;

public abstract class Protector
implements Runnable {
    private static int timeout = 8000;
    private String name;
    private Object result;
    private RequestProcessor.Task task;

    public static void setTimeout(int t) {
        timeout = t;
    }

    public static int getTimeout() {
        return timeout;
    }

    public Protector(String name) {
        this.name = name;
    }

    public void go(RequestSynchronizer synchronizer, RequestSynchronizer.RequestWaiter killer) {
        if (synchronizer.requestorThread != null && Thread.currentThread().equals(synchronizer.requestorThread)) {
            this.run();
        } else {
            synchronizer.postRequest(this, timeout, killer);
        }
    }

    public Object wait(RequestSynchronizer synchronizer, RequestSynchronizer.RequestWaiter killer) {
        if (synchronizer.requestorThread != null && Thread.currentThread().equals(synchronizer.requestorThread)) {
            this.run();
        } else {
            synchronizer.postRequestAndWait(this, timeout, killer);
        }
        return this.getResult();
    }

    public Object throwAndWait(RequestSynchronizer synchronizer, RequestSynchronizer.RequestWaiter killer) throws Exception {
        if (synchronizer.requestorThread != null && Thread.currentThread().equals(synchronizer.requestorThread)) {
            this.run();
        } else {
            synchronizer.postRequestAndWait(this, timeout, killer);
        }
        return this.getResultOrThrow();
    }

    public void go(final RequestSynchronizer.RequestWaiter killer) {
        final Thread t = new Thread((Runnable)this, "Thread " + this.name + " protector");
        this.task = killer == null ? RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                t.interrupt();
                t.stop();
            }
        }, (int)timeout) : RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                killer.run(t);
            }
        }, (int)timeout);
        t.start();
    }

    public synchronized Object wait(final RequestSynchronizer.RequestWaiter killer) {
        final Thread t = new Thread((Runnable)this, "Thread " + this.name + " protector");
        this.task = killer == null ? RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                t.interrupt();
                t.stop();
            }
        }, (int)timeout) : RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                killer.run(t);
            }
        }, (int)timeout);
        t.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getResult();
    }

    public synchronized Object throwAndWait(final RequestSynchronizer.RequestWaiter killer) throws Exception {
        final Thread t = new Thread((Runnable)this, "Thread " + this.name + " protector");
        this.task = killer == null ? RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                t.interrupt();
                t.stop();
            }
        }, (int)timeout) : RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                killer.run(t);
            }
        }, (int)timeout);
        t.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getResultOrThrow();
    }

    public abstract Object protect() throws Exception;

    public static RequestProcessor.Task register(String s) {
        final Thread t = Thread.currentThread();
        Runnable r = new Runnable(){

            public void run() {
                t.interrupt();
            }
        };
        RequestProcessor.Task ta = RequestProcessor.postRequest((Runnable)r, (int)timeout);
        return ta;
    }

    public final synchronized void run() {
        block3: {
            try {
                this.result = this.protect();
            }
            catch (Throwable t) {
                this.result = t;
                if (!(t instanceof ThreadDeath)) break block3;
                this.notify();
                throw (ThreadDeath)t;
            }
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.notify();
    }

    public String toString() {
        return this.name;
    }

    private Object getResultOrThrow() throws Exception {
        if (this.result instanceof Throwable) {
            if (this.result instanceof Error) {
                throw (Error)this.result;
            }
            if (this.result instanceof Exception) {
                throw (Exception)this.result;
            }
        }
        return this.result;
    }

    private Object getResult() {
        if (this.result instanceof Throwable) {
            if (this.result instanceof Error) {
                throw (Error)this.result;
            }
            if (this.result instanceof RuntimeException) {
                throw (RuntimeException)this.result;
            }
        }
        return this.result;
    }
}

