/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openide.windows.WindowManager;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static int processorCount = 0;
    private static long counter = 0L;
    final SortedSet waiting = new TreeSet(new TimeComp());
    private ProcessorThread thread;
    private String name;
    private static Debug debug;

    public RequestProcessor() {
    }

    public RequestProcessor(String name) {
        this.name = name;
    }

    protected void finalize() {
        this.stop();
    }

    public Task post(Runnable run) {
        return this.post(run, 0, 1);
    }

    public Task post(Runnable run, int timeToWait) {
        return this.post(run, timeToWait, 1);
    }

    public Task post(Runnable run, int timeToWait, int priority) {
        Task t;
        SortedSet sortedSet = this.waiting;
        synchronized (sortedSet) {
            t = new Task(run, timeToWait, priority);
            this.waiting.add(t.createHolder());
            this.checkTimerQueue();
        }
        if (debug != null && this == DEFAULT) {
            debug.notifyPost(t);
        }
        return t;
    }

    public Task create(Runnable run) {
        return new Task(run, 0L, 1);
    }

    public boolean isRequestProcessorThread() {
        return Thread.currentThread().equals(this.thread);
    }

    public void stop() {
        SortedSet sortedSet = this.waiting;
        synchronized (sortedSet) {
            if (this.thread != null) {
                this.thread.stopProcessing();
                this.thread = null;
            }
        }
    }

    public static Task postRequest(Runnable run) {
        return DEFAULT.post(run);
    }

    public static Task postRequest(Runnable run, int timeToWait) {
        return DEFAULT.post(run, timeToWait);
    }

    public static Task postRequest(Runnable run, int timeToWait, int priority) {
        return DEFAULT.post(run, timeToWait, priority);
    }

    public static Task createRequest(Runnable run) {
        return DEFAULT.create(run);
    }

    void checkTimerQueue() {
        if (this.thread == null) {
            this.thread = new ProcessorThread(this.name, this);
            this.thread.start();
        } else {
            if (this.waiting.size() == 0) {
                return;
            }
            this.waiting.notify();
        }
    }

    static ThreadGroup getTopLevelThreadGroup() {
        PrivilegedAction run = new PrivilegedAction(){

            public Object run() {
                ThreadGroup current = Thread.currentThread().getThreadGroup();
                while (current.getParent() != null) {
                    current = current.getParent();
                }
                return current;
            }
        };
        return (ThreadGroup)AccessController.doPrivileged(run);
    }

    static {
        if (System.getProperty("netbeans.debug.requests") != null) {
            debug = new Debug();
        } else {
            WindowManager.getDefault().getMainWindow().addKeyListener(new Debug());
        }
    }

    private static class Debug
    implements KeyListener {
        private Debug() {
        }

        public void keyReleased(KeyEvent p0) {
        }

        public void keyPressed(KeyEvent ev) {
            if ((ev.getModifiers() & 2) != 0 && (ev.getModifiers() & 8) != 0 && ev.getKeyCode() == 121) {
                debug = this;
                this.printRequestProcessor();
            }
        }

        public void keyTyped(KeyEvent ev) {
        }

        private void printRequestProcessor() {
            ProcessorThread thread = DEFAULT.thread;
            if (thread != null) {
                System.err.println("Content of " + thread + " sleep for: " + thread.sleep + " ago: " + (System.currentTimeMillis() - thread.at));
            } else {
                System.err.println("Content of " + thread);
            }
            LinkedList ll = new LinkedList(DEFAULT.waiting);
            this.print(ll);
            if (thread != null) {
                System.err.println("Pending requests");
                this.print(new LinkedList(thread.pending));
            }
        }

        private void print(Collection ll) {
            Iterator it = ll.iterator();
            int i = 0;
            while (it.hasNext()) {
                Holder h = (Holder)it.next();
                Task t = h.task;
                System.err.print("  ");
                System.err.print(++i);
                System.err.print(". ");
                System.err.println(t);
            }
        }

        public void notifySleep(int timeOut) {
            ProcessorThread thread = DEFAULT.thread;
            System.err.println("Sleeping for " + timeOut + " " + thread);
        }

        public void notifyPost(Task t) {
            ProcessorThread thread = DEFAULT.thread;
            System.err.println("Post: " + t + " to " + thread);
            this.printRequestProcessor();
        }

        public void notifyRun(Task t, Holder h) {
            ProcessorThread thread = DEFAULT.thread;
            System.err.println("Run: " + t + " to " + thread + " because of holder: " + h);
        }
    }

    private static final class PriorityComp
    implements Comparator {
        private PriorityComp() {
        }

        public int compare(Object o1, Object o2) {
            Holder h1 = (Holder)o1;
            Holder h2 = (Holder)o2;
            if (h1.priority == h2.priority) {
                Task t1 = h1.task;
                Task t2 = h2.task;
                if (h1.task == h2.task) {
                    return 0;
                }
                long code = System.identityHashCode(t1) - System.identityHashCode(t2);
                if (code == 0L) {
                    code = h1.task.id - h2.task.id;
                }
                return code > 0L ? 1 : -1;
            }
            if (h1.priority < h2.priority) {
                return 1;
            }
            return -1;
        }
    }

    private static final class TimeComp
    implements Comparator {
        private TimeComp() {
        }

        public int compare(Object o1, Object o2) {
            Holder h1 = (Holder)o1;
            Holder h2 = (Holder)o2;
            if (h1.time == h2.time) {
                Task t1 = h1.task;
                Task t2 = h2.task;
                if (h1.task == h2.task) {
                    return 0;
                }
                long code = System.identityHashCode(t1) - System.identityHashCode(t2);
                if (code == 0L) {
                    code = h1.task.id - h2.task.id;
                }
                return code > 0L ? 1 : -1;
            }
            if (h1.time > h2.time) {
                return 1;
            }
            return -1;
        }
    }

    private static final class ProcessorThread
    extends Thread {
        private TreeSet pending = new TreeSet(new PriorityComp());
        private Reference requestProcessor;
        private boolean stop;
        private int priority;
        Object sleep;
        long at;

        public ProcessorThread(String name, RequestProcessor requestProcessor) {
            super(RequestProcessor.getTopLevelThreadGroup(), name == null ? "Debugger Request Processor" : name);
            this.setDaemon(true);
            this.priority = this.getPriority();
            this.requestProcessor = new WeakReference<RequestProcessor>(requestProcessor);
        }

        public void stopProcessing() {
            this.stop = true;
            this.interrupt();
        }

        private long waitingToPending() {
            RequestProcessor rp = (RequestProcessor)this.requestProcessor.get();
            if (rp == null || rp.waiting.isEmpty()) {
                return 0L;
            }
            Iterator it = rp.waiting.iterator();
            while (it.hasNext()) {
                Holder holder = (Holder)it.next();
                if (holder.task == null) {
                    it.remove();
                    continue;
                }
                long diff = holder.time - System.currentTimeMillis();
                if (diff > 0L) {
                    return diff;
                }
                it.remove();
                this.pending.add(holder);
            }
            return 0L;
        }

        private Object synch() {
            RequestProcessor rp = (RequestProcessor)this.requestProcessor.get();
            if (rp == null) {
                throw new IllegalStateException();
            }
            return rp.waiting;
        }

        public void run() {
            int priority = this.getPriority();
            while (!this.stop) {
                Task t;
                Holder h;
                Object object = this.synch();
                synchronized (object) {
                    Iterator first;
                    while (true) {
                        h = null;
                        t = null;
                        first = null;
                        long w = this.waitingToPending();
                        if (!this.pending.isEmpty()) break;
                        try {
                            if (debug != null && this.requestProcessor.get() == DEFAULT) {
                                debug.notifySleep((int)w);
                            }
                            this.synch().wait(w);
                        }
                        catch (InterruptedException ex) {
                            if (this.stop) {
                                return;
                            }
                            throw new InternalError();
                        }
                    }
                    first = this.pending.iterator();
                    h = (Holder)first.next();
                    first.remove();
                    t = h.task;
                    if (t == null) {
                        continue;
                    }
                    t.holder = null;
                }
                int p = t.getPriority();
                if (priority != p) {
                    priority = p;
                    this.setPriority(priority);
                }
                try {
                    if (debug != null && this.requestProcessor.get() == DEFAULT) {
                        System.err.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
                        debug.notifyRun(t, h);
                        h.printStackTrace();
                    }
                    t.run();
                    if (debug == null || this.requestProcessor.get() != DEFAULT) continue;
                    System.err.println("Task finished: " + t);
                    debug.printRequestProcessor();
                    System.err.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable ex) {
                    if (System.getProperty("netbeans.debug.exceptions") == null) continue;
                    System.err.println("Request processor thread exception!");
                    ex.printStackTrace();
                }
            }
        }
    }

    public final class Task
    extends org.netbeans.modules.debugger.support.util.Task {
        long time;
        int priority;
        Holder holder;
        private long id;

        Task(Runnable run, long delay, int priority) {
            super(run);
            this.time = System.currentTimeMillis() + delay;
            this.priority = priority;
            this.id = counter++;
        }

        Holder createHolder() {
            if (this.holder != null) {
                this.holder.task = null;
            }
            this.holder = new Holder(this);
            return this.holder;
        }

        public int getDelay() {
            long delay = this.time - System.currentTimeMillis();
            if (delay < 0L) {
                return 0;
            }
            if (delay > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)delay;
        }

        public void schedule(int delay) {
            SortedSet sortedSet = RequestProcessor.this.waiting;
            synchronized (sortedSet) {
                this.time = System.currentTimeMillis() + (long)delay;
                RequestProcessor.this.waiting.add(this.createHolder());
                RequestProcessor.this.checkTimerQueue();
            }
        }

        public boolean cancel() {
            SortedSet sortedSet = RequestProcessor.this.waiting;
            synchronized (sortedSet) {
                if (this.holder != null) {
                    this.holder.task = null;
                    this.holder = null;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            if (this.priority != priority) {
                if (priority < 1) {
                    priority = 1;
                }
                if (priority > 10) {
                    priority = 10;
                }
                SortedSet sortedSet = RequestProcessor.this.waiting;
                synchronized (sortedSet) {
                    this.priority = priority;
                    if (this.holder != null) {
                        RequestProcessor.this.waiting.add(this.createHolder());
                        RequestProcessor.this.checkTimerQueue();
                    }
                }
            }
        }

        void waitFinishedImpl() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun = false;
                SortedSet sortedSet = RequestProcessor.this.waiting;
                synchronized (sortedSet) {
                    if (this.holder != null) {
                        this.holder.task = null;
                        this.holder = null;
                        toRun = true;
                    }
                }
                if (toRun) {
                    this.run();
                }
            } else {
                super.waitFinishedImpl();
            }
        }

        public String toString() {
            return super.toString() + " [" + (this.time - System.currentTimeMillis()) + ", " + this.priority + ']';
        }
    }

    private final class Holder {
        public Task task;
        public int priority;
        public long time;

        public void printStackTrace() {
        }

        public Holder(Task t) {
            this.task = t;
            this.priority = t.priority;
            this.time = t.time;
        }

        public String toString() {
            Task t = this.task;
            return t == null ? "null" : t.toString();
        }
    }
}

