/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import org.openide.util.RequestProcessor;

public class RequestSynchronizer {
    Integer LOCK = new Integer(0);
    Thread requestorThread = null;
    RequestProcessor processor = new RequestProcessor();
    RequestProcessor.Task task;
    long lastStart;
    boolean releaseOn = false;

    public synchronized void postRequest(final Runnable r, boolean wait) {
        if (this.releaseOn) {
            return;
        }
        Integer n = this.LOCK;
        synchronized (n) {
            if (this.requestorThread != null) {
                try {
                    this.LOCK.wait();
                    if (this.releaseOn) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.requestorThread = new Thread("Request " + r + " thread"){

                public void run() {
                    Integer n = RequestSynchronizer.this.LOCK;
                    synchronized (n) {
                        RequestSynchronizer.this.lastStart = System.currentTimeMillis();
                        try {
                            r.run();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        RequestSynchronizer.this.requestorThread = null;
                        RequestSynchronizer.this.LOCK.notify();
                    }
                }
            };
            this.requestorThread.start();
            try {
                if (wait) {
                    this.LOCK.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public synchronized void postRequest(Runnable r) {
        this.postRequest(r, false);
    }

    public synchronized void postRequestAndWait(Runnable r) {
        this.postRequest(r, true);
    }

    public synchronized void postRequest(Runnable r, int time) {
        this.postRequest(r, time, new RequestWaiter(){

            public void run(Thread t) {
                RequestSynchronizer.this.requestorThread.interrupt();
                RequestSynchronizer.this.requestorThread.stop();
            }
        });
    }

    public synchronized void postRequestAndWait(Runnable r, int time) {
        this.postRequest(r, time, new RequestWaiter(){

            public void run(Thread t) {
                RequestSynchronizer.this.requestorThread.interrupt();
                RequestSynchronizer.this.requestorThread.stop();
            }
        });
    }

    public synchronized void postRequest(Runnable quest, int time, final RequestWaiter waiter) {
        if (this.releaseOn) {
            return;
        }
        this.postRequest(quest);
        final Thread t = this.requestorThread;
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                if (RequestSynchronizer.this.requestorThread == null) {
                    return;
                }
                if (t == RequestSynchronizer.this.requestorThread) {
                    long timeR = System.currentTimeMillis() - RequestSynchronizer.this.lastStart;
                    waiter.run(RequestSynchronizer.this.requestorThread);
                }
            }
        }, (int)time);
    }

    public synchronized void postRequestAndWait(Runnable quest, int time, final RequestWaiter waiter) {
        if (this.releaseOn) {
            return;
        }
        Integer n = this.LOCK;
        synchronized (n) {
            this.postRequest(quest);
            final Thread t = this.requestorThread;
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    if (RequestSynchronizer.this.requestorThread == null) {
                        return;
                    }
                    if (t == RequestSynchronizer.this.requestorThread) {
                        long timeR = System.currentTimeMillis() - RequestSynchronizer.this.lastStart;
                        waiter.run(RequestSynchronizer.this.requestorThread);
                    }
                }
            }, (int)time);
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void releaseAll() {
        this.releaseOn = true;
        if (this.requestorThread != null) {
            this.requestorThread.interrupt();
            this.requestorThread.stop();
        }
    }

    public static interface RequestWaiter {
        public void run(Thread var1);
    }
}

