/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.support.util.AbstractHistory;

public class SimpleHistory
extends AbstractHistory
implements Serializable {
    private static final long serialVersionUID = -6570627254472789661L;
    protected final int maxSize;
    protected final ArrayList items;

    public SimpleHistory(int maxSize, String[] elements) {
        this.maxSize = maxSize;
        this.items = new ArrayList(maxSize);
        if (elements != null) {
            int size = elements.length;
            if (size > maxSize) {
                size = maxSize;
            }
            int i = 0;
            while (i < size) {
                this.items.add(elements[i]);
                ++i;
            }
        }
    }

    public void addItem(Object item) {
        if (!this.items.contains(item)) {
            if (this.items.size() == this.maxSize) {
                Object lost = this.items.remove(0);
                this.items.add(item);
                this.fireShifted(lost, item);
            } else {
                this.items.add(item);
                this.fireAdded(item);
            }
        }
    }

    public List getItems() {
        if (this.items.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.items);
    }

    public String[] getItemsAsArray() {
        if (this.items.isEmpty()) {
            return new String[0];
        }
        String[] array = new String[this.items.size()];
        return this.items.toArray(array);
    }

    public int getSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

