/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.awt.Window;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.GUIManager;
import org.netbeans.modules.debugger.support.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.support.actions.DebuggerWindowPerformer;
import org.netbeans.modules.debugger.support.nodes.DebuggerWindow;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class Utils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static Comparator localsComparator = new Comparator(){

        public int compare(Object o1, Object o2) throws ClassCastException {
            return ((AbstractVariable)o1).getVariableName().compareToIgnoreCase(((AbstractVariable)o2).getVariableName());
        }
    };
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$util$Utils;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    static String getString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$util$Utils == null ? (class$org$netbeans$modules$debugger$support$util$Utils = Utils.class$("org.netbeans.modules.debugger.support.util.Utils")) : class$org$netbeans$modules$debugger$support$util$Utils), (String)s);
    }

    public static void setViewVisibility(final GUIManager.View v, final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebuggerWindow dw = DebuggerWindowPerformer.getDebuggerWindow();
                dw.setVisible(v, visible);
            }
        });
    }

    public static RuntimeException localizeException(Exception e, String text) {
        return new ExceptionHack(e, text);
    }

    protected static String removeQuotationMarks(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"")) {
            s = s.substring(1, s.length());
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static Line showInEditor(final Line line) {
        if (line == null) {
            return null;
        }
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

            public void run() {
                try {
                    line.show(2);
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(e, (Object)Utils.getString("EXC_Editor")));
                }
                DataObject dob = line.getDataObject();
                if (dob == null) {
                    return;
                }
                EditorCookie ec = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = 2.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (ec == null) {
                    return;
                }
                JEditorPane[] eps = ec.getOpenedPanes();
                if (eps == null || eps.length < 1) {
                    return;
                }
                Window w = SwingUtilities.getWindowAncestor(eps[0]);
                if (w != null) {
                    w.toFront();
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        return line;
    }

    public static String getExceptionName(String errorText) {
        try {
            int index1 = errorText.indexOf(58) + 1;
            String s = errorText.substring(index1);
            s = s.trim();
            index1 = s.indexOf(58);
            int index2 = s.indexOf(32);
            if (index2 >= 0 && index2 < index1) {
                index1 = index2;
            }
            if ((index2 = s.indexOf(10)) >= 0 && index2 < index1) {
                index1 = index2;
            }
            if ((index2 = s.indexOf(9)) >= 0 && index2 < index1) {
                index1 = index2;
            }
            if ((s = s.substring(0, index1).trim()).length() == 0) {
                return null;
            }
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String getSelectedText() {
        JEditorPane ep = Utils.getCurrentEditor();
        if (ep == null) {
            return null;
        }
        return ep.getSelectedText();
    }

    public static EditorCookie getCurrentEditorCookie() {
        AddBreakpointAction aba = (AddBreakpointAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction = Utils.class$("org.netbeans.modules.debugger.support.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$support$actions$AddBreakpointAction));
        Node[] nodes = aba.getActivatedNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        Node n = nodes[0];
        return (EditorCookie)n.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = Utils.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
    }

    public static JEditorPane getCurrentEditor() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    public static JEditorPane getCurrentEditor(EditorCookie e) {
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    public static int getCurrentLineNumber() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = Utils.getCurrentEditor(e);
        if (ep == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)e.getDocument(), (int)ep.getCaret().getDot()) + 1;
    }

    public static Line getCurrentLine() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = Utils.getCurrentEditor(e);
        if (ep == null) {
            return null;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return null;
        }
        Line.Set ls = e.getLineSet();
        if (ls == null) {
            return null;
        }
        Caret c = ep.getCaret();
        if (c == null) {
            return null;
        }
        Line l = ls.getCurrent(NbDocument.findLineNumber((StyledDocument)d, (int)c.getDot()));
        if (l == null || l.getDataObject() == null || l.getDataObject().getPrimaryFile() == null) {
            return null;
        }
        try {
            FileSystem fs = l.getDataObject().getPrimaryFile().getFileSystem();
            if (fs.getCapability().capableOf(GUIManager.DEBUG_SRC)) {
                return l;
            }
            if (fs.isHidden()) {
                return null;
            }
            return l;
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    public static Node.Property createProperty(Object instance, Class type, String name, String dispName, String shortDesc, String getter, String setter) {
        PropertySupport.Reflection prop;
        try {
            prop = new PropertySupport.Reflection(instance, type, getter, setter);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        prop.setName(name);
        prop.setDisplayName(dispName);
        prop.setShortDescription(shortDesc);
        return prop;
    }

    public static final String[] getPackageNames(boolean ignoreCVS, boolean ignoreMeta, boolean ignoreResources) {
        PackageTree root = Utils.buildPackageTree();
        PackageTree[] packages = root.getSubpackages();
        int count = packages.length;
        if (count == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>(20);
        if (count > 1) {
            Arrays.sort(packages, PackageTree.getComparator());
        }
        int i = 0;
        while (i < count) {
            PackageTree pkg = packages[i];
            String name = pkg.getPackageName();
            if (!(ignoreMeta && name.equals("META-INF") || ignoreCVS && pkg.isLeaf() && name.equals("CVS") || ignoreResources && name.equals("resources"))) {
                result.add(name);
                Utils.addPackageNames(result, name, pkg, ignoreCVS, ignoreResources);
            }
            ++i;
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    private static final void addPackageNames(List result, String packageName, PackageTree subtree, boolean ignoreCVS, boolean ignoreResources) {
        PackageTree[] subpackages = subtree.getSubpackages();
        int count = subpackages.length;
        if (count == 0) {
            return;
        }
        if (count > 1) {
            Arrays.sort(subpackages, PackageTree.getComparator());
        }
        String packageNameDot = packageName + '.';
        int i = 0;
        while (i < count) {
            PackageTree subpackage = subpackages[i];
            String name = subpackage.getPackageName();
            if (!(ignoreCVS && subpackage.isLeaf() && name.equals("CVS") || ignoreResources && name.equals("resources"))) {
                String qualifiedName = packageNameDot + name;
                result.add(qualifiedName);
                Utils.addPackageNames(result, qualifiedName, subpackage, ignoreCVS, ignoreResources);
            }
            ++i;
        }
    }

    private static final PackageTree buildPackageTree() {
        Repository rep = Repository.getDefault();
        Enumeration fsEnum = rep.getFileSystems();
        PackageTree root = new PackageTree("");
        while (fsEnum.hasMoreElements()) {
            FileSystem fs = (FileSystem)fsEnum.nextElement();
            if (fs.isDefault() || !fs.getCapability().capableOf(FileSystemCapability.DEBUG)) continue;
            FileObject fo = fs.getRoot();
            Utils.processPackage(fo, root);
        }
        return root;
    }

    private static final void processPackage(FileObject folder, PackageTree tree) {
        Enumeration enumeration = folder.getFolders(false);
        if (!enumeration.hasMoreElements()) {
            return;
        }
        ArrayList subfoldersList = new ArrayList(10);
        do {
            subfoldersList.add(enumeration.nextElement());
        } while (enumeration.hasMoreElements());
        int count = subfoldersList.size();
        enumeration = null;
        String[] names = new String[count];
        FileObject[] subfolders = new FileObject[count];
        Iterator iter = ((AbstractList)subfoldersList).iterator();
        int i = 0;
        while (i < count) {
            FileObject subfolder;
            subfolders[i] = subfolder = (FileObject)iter.next();
            names[i] = subfolder.getName();
            ++i;
        }
        iter = null;
        subfoldersList = null;
        PackageTree[] subpackages = tree.addSubpackages(names);
        names = null;
        int i2 = 0;
        while (i2 < count) {
            Utils.processPackage(subfolders[i2], subpackages[i2]);
            ++i2;
        }
    }

    public static String getIdentifier() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = Utils.getCurrentEditor(e);
        if (ep == null) {
            return null;
        }
        return Utils.getIdentifier(e.getDocument(), ep, ep.getCaret().getDot());
    }

    public static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            int identStart = col;
            while (identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.')) {
                --identStart;
            }
            int identEnd = col;
            while (identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd))) {
                ++identEnd;
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExceptionHack
    extends RuntimeException {
        private Throwable t;
        private String text;

        ExceptionHack(Throwable t, String text) {
            super("");
            this.t = t;
            this.text = text;
        }

        public String getMessage() {
            return this.text + " ";
        }

        public String getLocalizedMessage() {
            return this.text;
        }

        public void printStackTrace(PrintStream s) {
            this.t.printStackTrace(s);
        }

        public void printStackTrace(PrintWriter s) {
            this.t.printStackTrace(s);
        }
    }

    private static final class PackageTree {
        private static final PackageTree[] EMPTY_PACKAGE_ARRAY = new PackageTree[0];
        private static Comparator comparator;
        private final String packageName;
        private PackageTree[] subpackages;

        private PackageTree(String name) {
            this.packageName = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String[] getSubpackagesNames() {
            if (this.subpackages == null) {
                return EMPTY_STRING_ARRAY;
            }
            int len = this.subpackages.length;
            String[] result = new String[len];
            int i = 0;
            while (i < len) {
                result[i] = this.subpackages[i].packageName;
                ++i;
            }
            return result;
        }

        public PackageTree[] getSubpackages() {
            if (this.subpackages == null) {
                return EMPTY_PACKAGE_ARRAY;
            }
            PackageTree[] result = new PackageTree[this.subpackages.length];
            System.arraycopy(this.subpackages, 0, result, 0, this.subpackages.length);
            return result;
        }

        public boolean isLeaf() {
            return this.subpackages == null;
        }

        public PackageTree[] addSubpackages(String[] names) {
            int len = names.length;
            if (len == 0) {
                return EMPTY_PACKAGE_ARRAY;
            }
            if (this.subpackages == null) {
                this.subpackages = new PackageTree[len];
                int i = 0;
                while (i < len) {
                    this.subpackages[i] = new PackageTree(names[i]);
                    ++i;
                }
                return this.subpackages;
            }
            HashMap<String, PackageTree> map = new HashMap<String, PackageTree>((int)Math.ceil((double)(this.subpackages.length + names.length) * 1.35), 0.75f);
            int curLen = this.subpackages.length;
            int i = 0;
            while (i < curLen) {
                PackageTree pt = this.subpackages[i];
                map.put(pt.packageName, pt);
                ++i;
            }
            int newEntriesCount = 0;
            PackageTree[] newEntries = new PackageTree[len];
            PackageTree[] argSubpackages = new PackageTree[len];
            int i2 = 0;
            while (i2 < len) {
                String name = names[i2];
                Object curEntry = map.get(name);
                if (curEntry == null) {
                    PackageTree newEntry = new PackageTree(name);
                    map.put(name, newEntry);
                    newEntries[newEntriesCount++] = newEntry;
                    argSubpackages[i2] = newEntry;
                } else {
                    argSubpackages[i2] = (PackageTree)curEntry;
                }
                ++i2;
            }
            if (newEntriesCount > 0) {
                PackageTree[] oldSubpackagesList = this.subpackages;
                this.subpackages = new PackageTree[curLen + newEntriesCount];
                System.arraycopy(oldSubpackagesList, 0, this.subpackages, 0, curLen);
                System.arraycopy(newEntries, 0, this.subpackages, curLen, newEntriesCount);
            }
            return argSubpackages;
        }

        public static Comparator getComparator() {
            if (comparator == null) {
                comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        PackageTree t1 = (PackageTree)o1;
                        PackageTree t2 = (PackageTree)o2;
                        return PackageTree.access$200(t1).compareTo(PackageTree.access$200(t2));
                    }
                };
            }
            return comparator;
        }

        static /* synthetic */ String access$200(PackageTree x0) {
            return x0.packageName;
        }
    }
}

