/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.support.util.RequestProcessor;

public class ValidatorImpl
implements Validator {
    private WeakHashMap objects = new WeakHashMap();
    private HashMap tasks = new HashMap();
    private int waitingTasks = 0;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ValidatingTask task = null;

    public void add(Validator.Object object) {
        WeakHashMap weakHashMap = this.objects;
        synchronized (weakHashMap) {
            this.objects.put(object, null);
        }
    }

    public void remove(Validator.Object object) {
        WeakHashMap weakHashMap = this.objects;
        synchronized (weakHashMap) {
            this.objects.remove(object);
        }
    }

    public synchronized void validate() {
        if (this.task != null) {
            this.task.finish();
        }
        LinkedList list = new LinkedList();
        WeakHashMap weakHashMap = this.objects;
        synchronized (weakHashMap) {
            Iterator keys = ((AbstractMap)this.objects).keySet().iterator();
            try {
                while (keys.hasNext()) {
                    list.add(keys.next());
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        this.task = new ValidatingTask(list, this.pcs);
        RequestProcessor.postRequest(this.task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void clear() {
        Iterator i;
        WeakHashMap weakHashMap = this.objects;
        synchronized (weakHashMap) {
            i = ((AbstractList)new ArrayList(((AbstractMap)this.objects).keySet())).iterator();
        }
        while (i.hasNext()) {
            Validator.Object o = (Validator.Object)i.next();
            if (o == null) continue;
            Validator.Object object = o;
            synchronized (object) {
                if (o.canRemove()) {
                    this.remove(o);
                }
            }
        }
    }

    public boolean isValidated() {
        return this.task == null ? true : this.task.isFinished();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public class ValidatingTask
    implements Runnable {
        private boolean finished = false;
        private PropertyChangeSupport pcs;
        private List objects;

        public ValidatingTask(List objects, PropertyChangeSupport pcs) {
            this.objects = objects;
            this.pcs = pcs;
        }

        public void finish() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void run() {
            Iterator i = this.objects.iterator();
            if (i.hasNext()) {
                this.pcs.firePropertyChange(null, null, null);
                while (i.hasNext() && !this.finished) {
                    Validator.Object o = (Validator.Object)i.next();
                    if (o == null) continue;
                    try {
                        o.validate();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.finished = true;
                this.pcs.firePropertyChange(null, null, null);
            }
            this.objects = null;
        }
    }
}

