/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.text.completion.XMLResultItem;

class ElementResultItem
extends XMLResultItem {
    private final boolean startElement;

    public ElementResultItem(GrammarResult res) {
        super(res.getNodeName());
        this.foreground = Color.blue;
        this.startElement = true;
    }

    public ElementResultItem(String name) {
        super(name);
        this.foreground = Color.blue;
        this.startElement = false;
    }

    public String getReplacementText(int modifiers) {
        boolean shift;
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift && this.startElement) {
            return this.displayText + "></" + this.displayText + '>';
        }
        if (this.startElement) {
            return this.displayText;
        }
        return this.displayText + '>';
    }

    public boolean substituteText(JTextComponent c, int offset, int len, int modifiers) {
        boolean shift;
        String replacementText = this.getReplacementText(modifiers);
        this.replaceText(c, replacementText, offset, len);
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift && this.startElement) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            int rlen = replacementText.length();
            caret.setDot(dot - rlen + replacementText.indexOf(60));
        }
        return false;
    }
}

