/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.xml.parsers.DocumentInputSource;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarQueryManager;
import org.netbeans.modules.xml.spi.model.EmptyQuery;
import org.netbeans.modules.xml.text.completion.Util;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.enum.QueueEnumeration;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class GrammarManager
implements DocumentListener {
    private int state = 3;
    static final int VALID = 1;
    static final int INVALID = 3;
    private GrammarQuery grammar;
    private final XMLSyntaxSupport syntax;
    private final Document doc;
    private Position[] guarded;
    private Position maxGuarded;

    public GrammarManager(Document doc, XMLSyntaxSupport syntax) {
        this.doc = doc;
        this.syntax = syntax;
    }

    public synchronized GrammarQuery getGrammar() {
        switch (this.state) {
            case 1: {
                return this.grammar;
            }
            case 3: {
                this.loadGrammar();
                return this.grammar;
            }
        }
        throw new IllegalStateException();
    }

    public synchronized void invalidateGrammar() {
        if (this.state == 1) {
            String msg = Util.THIS.getString("MSG_loading_cancel");
            StatusDisplayer.getDefault().setStatusText(msg);
        }
        this.doc.removeDocumentListener(this);
        this.guarded = new Position[0];
        this.state = 3;
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.isGuarded(e.getOffset(), e.getLength())) {
            this.invalidateGrammar();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.isGuarded(e.getOffset(), e.getLength())) {
            this.invalidateGrammar();
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private boolean isGuarded(int offset, int length) {
        if (offset > this.maxGuarded.getOffset()) {
            return false;
        }
        int i = 0;
        while (i < this.guarded.length) {
            int start = this.guarded[i].getOffset();
            int end = this.guarded[i + 1].getOffset();
            if (start < offset && offset < end) {
                return true;
            }
            int changeEnd = offset + length;
            if (offset < start && start < changeEnd) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private synchronized void grammarLoaded(GrammarQuery grammar) {
        String status = grammar != null ? Util.THIS.getString("MSG_loading_done") : Util.THIS.getString("MSG_loading_failed");
        this.grammar = grammar == null ? EmptyQuery.INSTANCE : grammar;
        this.state = 1;
        StatusDisplayer.getDefault().setStatusText(status);
    }

    private void loadGrammar() {
        GrammarQuery loaded = null;
        try {
            String status = Util.THIS.getString("MSG_loading");
            StatusDisplayer.getDefault().setStatusText(status);
            try {
                QueueEnumeration ctx = new QueueEnumeration();
                for (SyntaxElement first = this.syntax.getElementChain(1); first != null; first = first.getNext()) {
                    if (!(first instanceof SyntaxNode)) continue;
                    SyntaxNode node = (SyntaxNode)first;
                    ctx.put((Object)node);
                    if (1 == node.getNodeType()) break;
                }
                DocumentInputSource inputSource = new DocumentInputSource(this.doc);
                FileObject fileObject = null;
                Object obj = this.doc.getProperty("stream");
                if (obj instanceof DataObject) {
                    DataObject dobj = (DataObject)obj;
                    fileObject = dobj.getPrimaryFile();
                }
                GrammarEnvironment env = new GrammarEnvironment((Enumeration)ctx, (InputSource)inputSource, fileObject);
                GrammarQueryManager g = GrammarQueryManager.getDefault();
                Enumeration en = g.enabled(env);
                if (en == null) {
                    Object var20_12 = null;
                    this.grammarLoaded(loaded);
                    return;
                }
                ArrayList<Position> positions = new ArrayList<Position>(10);
                int max = 0;
                while (en.hasMoreElements()) {
                    Node next = (Node)en.nextElement();
                    if (!(next instanceof SyntaxNode)) continue;
                    SyntaxNode node = (SyntaxNode)next;
                    int start = node.getElementOffset();
                    int end = start + node.getElementLength();
                    if (end > max) {
                        max = end;
                    }
                    Position startPosition = NbDocument.createPosition((Document)this.doc, (int)start, (Position.Bias)Position.Bias.Forward);
                    positions.add(startPosition);
                    Position endPosition = NbDocument.createPosition((Document)this.doc, (int)end, (Position.Bias)Position.Bias.Backward);
                    positions.add(endPosition);
                }
                this.guarded = positions.toArray(new Position[positions.size()]);
                this.maxGuarded = NbDocument.createPosition((Document)this.doc, (int)max, (Position.Bias)Position.Bias.Backward);
                loaded = g.getGrammar(env);
                this.doc.addDocumentListener(this);
            }
            catch (BadLocationException ex) {
                loaded = null;
            }
        }
        catch (Throwable throwable) {
            Object var20_14 = null;
            this.grammarLoaded(loaded);
            throw throwable;
        }
        Object var20_13 = null;
        this.grammarLoaded(loaded);
    }
}

