/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.text.completion.SyntaxQueryHelper;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class NodeSelector {
    private CaretListener caretListener;
    private Timer timerSelNodes;
    private int lastCaretOffset = -1;
    private static final int SELECTED_NODES_DELAY = 200;
    private JEditorPane pane;
    private XMLSyntaxSupport syntaxSupport;
    private Node originalUINode;
    HintContext hintContext;

    public NodeSelector(final JEditorPane pane) {
        this.pane = pane;
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                NodeSelector.this.restartTimerSelNodes(e.getDot());
            }
        };
        this.timerSelNodes = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Caret caret;
                if (NodeSelector.this.lastCaretOffset == -1 && pane != null && (caret = pane.getCaret()) != null) {
                    NodeSelector.this.lastCaretOffset = caret.getDot();
                }
                NodeSelector.this.selectElementsAtOffset(NodeSelector.this.lastCaretOffset);
            }
        });
        this.timerSelNodes.setInitialDelay(100);
        this.timerSelNodes.setRepeats(false);
        this.timerSelNodes.restart();
        pane.addCaretListener(this.caretListener);
    }

    void restartTimerSelNodes(int pos) {
        this.timerSelNodes.setInitialDelay(200);
        this.lastCaretOffset = pos;
        this.timerSelNodes.restart();
    }

    synchronized void selectElementsAtOffset(int offset) {
        GrammarQuery grammarQuery;
        if (this.syntaxSupport == null) {
            Document doc = this.pane.getDocument();
            if (doc instanceof BaseDocument) {
                this.syntaxSupport = (XMLSyntaxSupport)((BaseDocument)doc).getSyntaxSupport();
            }
            if (this.syntaxSupport == null) {
                return;
            }
        }
        Container parent = this.pane.getParent();
        while (parent != null && !(parent instanceof TopComponent)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return;
        }
        TopComponent topComp = (TopComponent)parent;
        Node[] activeNodes = topComp.getActivatedNodes();
        if (activeNodes == null || activeNodes.length == 0) {
            return;
        }
        if (this.originalUINode == null) {
            this.originalUINode = activeNodes[0];
        }
        if ((grammarQuery = XMLCompletionQuery.getPerformer(this.pane.getDocument(), this.syntaxSupport)) == null) {
            return;
        }
        SyntaxQueryHelper helper = null;
        try {
            helper = new SyntaxQueryHelper(this.syntaxSupport, offset);
        }
        catch (BadLocationException e) {
            topComp.setActivatedNodes(new Node[]{new DelegatingNode(this.originalUINode, null, null)});
            return;
        }
        DelegatingNode newUiNode = new DelegatingNode(this.originalUINode, grammarQuery, helper.getContext());
        topComp.setActivatedNodes(new Node[]{newUiNode});
    }

    private class AttributeProperty
    extends PropertySupport {
        private final String propName;
        private final Element ownerElem;
        private boolean canWrite = true;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$netbeans$modules$xml$text$completion$NodeSelector;

        public AttributeProperty(Element ownerElem, String propName) {
            super(propName, class$java$lang$String == null ? (class$java$lang$String = AttributeProperty.class$("java.lang.String")) : class$java$lang$String, propName, propName, true, true);
            this.ownerElem = ownerElem;
            this.propName = propName;
        }

        public void setValue(Object value) {
            try {
                this.ownerElem.setAttribute(this.propName, (String)value);
            }
            catch (DOMException ex) {
                this.canWrite = false;
            }
        }

        public Object getValue() {
            try {
                return this.ownerElem.getAttribute(this.propName);
            }
            catch (DOMException ex) {
                this.canWrite = false;
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$text$completion$NodeSelector == null ? (class$org$netbeans$modules$xml$text$completion$NodeSelector = AttributeProperty.class$("org.netbeans.modules.xml.text.completion.NodeSelector")) : class$org$netbeans$modules$xml$text$completion$NodeSelector), (String)"BK0001");
            }
        }

        public boolean canWrite() {
            return this.canWrite;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class DelegatingNode
    extends FilterNode {
        GrammarQuery grammarQuery;
        HintContext hintContext;
        Sheet propSheet;

        public DelegatingNode(Node peer, GrammarQuery grammarQuery, HintContext hintContext) {
            super(peer);
            this.grammarQuery = grammarQuery;
            this.hintContext = hintContext;
        }

        public Component getCustomizer() {
            if (this.grammarQuery == null || this.hintContext == null) {
                return super.getCustomizer();
            }
            return this.grammarQuery.getCustomizer(this.hintContext);
        }

        public boolean hasCustomizer() {
            if (this.grammarQuery == null || this.hintContext == null) {
                return super.hasCustomizer();
            }
            return this.grammarQuery.hasCustomizer(this.hintContext);
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.propSheet == null) {
                Node.Property[] nodeProperties;
                this.propSheet = Sheet.createDefault();
                Sheet.Set nodePropertySet = this.propSheet.get("properties");
                if (this.grammarQuery != null && this.hintContext != null && (nodeProperties = this.grammarQuery.getProperties(this.hintContext)) != null && nodeProperties.length > 0) {
                    nodePropertySet.put(nodeProperties);
                    return this.propSheet.toArray();
                }
                org.w3c.dom.Node attributeOwningElem = null;
                if (this.hintContext != null) {
                    if (this.hintContext.getNodeType() == 1) {
                        attributeOwningElem = (Element)this.hintContext;
                    } else if (this.hintContext.getNodeType() == 2) {
                        attributeOwningElem = ((Attr)this.hintContext).getOwnerElement();
                    }
                }
                if (attributeOwningElem != null) {
                    NamedNodeMap attributes = attributeOwningElem.getAttributes();
                    int ind = 0;
                    while (ind < attributes.getLength()) {
                        org.w3c.dom.Node node = attributes.item(ind);
                        nodePropertySet.put((Node.Property)new AttributeProperty((Element)attributeOwningElem, node.getNodeName()));
                        ++ind;
                    }
                }
            }
            return this.propSheet.toArray();
        }
    }
}

