/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.text.completion.DefaultContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SyntaxQueryHelper {
    public static final int COMPLETION_TYPE_UNKNOWN = 0;
    public static final int COMPLETION_TYPE_ATTRIBUTE = 1;
    public static final int COMPLETION_TYPE_VALUE = 2;
    public static final int COMPLETION_TYPE_ELEMENT = 3;
    public static final int COMPLETION_TYPE_ENTITY = 4;
    public static final int COMPLETION_TYPE_NOTATION = 5;
    public static final int COMPLETION_TYPE_DTD = 6;
    private TokenItem token = null;
    private String preText = "";
    private int erase = 0;
    private int tunedOffset = 0;
    private SyntaxElement element;
    private int completionType = 0;
    private boolean boundary;
    private static DefaultContext ctx = new DefaultContext();
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$syntax$dom$StartTag;
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag;

    public SyntaxQueryHelper(XMLSyntaxSupport sup, int offset) throws BadLocationException, IllegalStateException {
        this.tunedOffset = offset;
        this.token = sup.getPreviousToken(this.tunedOffset);
        if (this.token == null) {
            throw new BadLocationException("No token found at current position", offset);
        }
        this.boundary = this.token.getOffset() + this.token.getImage().length() == this.tunedOffset;
        int itemOffset = this.token.getOffset();
        this.preText = "";
        this.erase = 0;
        int eraseRight = 0;
        int id = this.token.getTokenID().getNumericID();
        if (!this.boundary) {
            this.preText = this.token.getImage().substring(0, this.tunedOffset - this.token.getOffset());
            if ("".equals(this.preText)) {
                throw new IllegalStateException("Cannot get token prefix at " + this.tunedOffset);
            }
            switch (id) {
                case 4: 
                case 5: 
                case 11: {
                    int i = this.token.getImage().length();
                    int tail = i - (this.tunedOffset - itemOffset);
                    this.tunedOffset += tail;
                    eraseRight = tail;
                }
            }
        } else {
            switch (id) {
                case 1: 
                case 4: 
                case 5: 
                case 11: 
                case 15: {
                    this.preText = this.token.getImage();
                }
            }
        }
        switch (id) {
            case 4: 
            case 11: {
                this.erase = this.preText.length() - 1 + eraseRight;
                break;
            }
            case 5: {
                this.erase = this.preText.length() + eraseRight;
                break;
            }
            case 7: {
                this.erase = this.preText.length();
                if (this.erase <= 0 || this.preText.charAt(0) != '\'' && this.preText.charAt(0) != '\"') break;
                --this.erase;
            }
        }
        this.element = sup.getElementChain(this.tunedOffset);
        if (this.element == null) {
            throw new IllegalStateException("There exists a token therefore a syntax element must exist at " + offset + ", too.");
        }
        this.completionType = this.element instanceof SyntaxNode && ((SyntaxNode)this.element).getNodeType() != 10 ? this.initContext() : 6;
    }

    private int initContext() {
        int id = this.token.getTokenID().getNumericID();
        SyntaxNode syntaxNode = (SyntaxNode)this.element;
        switch (id) {
            case 1: {
                if (this.preText.endsWith("<")) {
                    ctx.init(syntaxNode, "");
                    return 3;
                }
                if (this.preText.startsWith("&")) {
                    ctx.init(syntaxNode, this.preText.substring(1));
                    return 4;
                }
                ctx.init(syntaxNode, this.preText);
                return 2;
            }
            case 4: {
                if ((class$org$netbeans$modules$xml$text$syntax$dom$StartTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$StartTag = SyntaxQueryHelper.class$("org.netbeans.modules.xml.text.syntax.dom.StartTag")) : class$org$netbeans$modules$xml$text$syntax$dom$StartTag).equals(syntaxNode.getClass()) || (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag = SyntaxQueryHelper.class$("org.netbeans.modules.xml.text.syntax.dom.EmptyTag")) : class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag).equals(syntaxNode.getClass())) {
                    if (this.preText.equals("")) {
                        if (this.token.getImage().endsWith(">")) {
                            ctx.init(syntaxNode, this.preText);
                            return 2;
                        }
                        ctx.init(syntaxNode, this.preText);
                        return 3;
                    }
                    if (this.preText.endsWith("/>")) {
                        ctx.init(syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.endsWith(">")) {
                        ctx.init(syntaxNode, "");
                        return 2;
                    }
                    if (this.preText.startsWith("</")) {
                        ctx.init(syntaxNode, this.preText.substring(2));
                        return 3;
                    }
                    if (!this.preText.startsWith("<")) break;
                    ctx.init(syntaxNode, this.preText.substring(1));
                    return 3;
                }
                if (!"".equals(this.preText) || !this.token.getImage().endsWith(">")) break;
                ctx.init(syntaxNode, this.preText);
                return 2;
            }
            case 7: {
                if (this.preText.endsWith("&")) {
                    ctx.init(syntaxNode, "");
                    return 4;
                }
                if ("".equals(this.preText)) {
                    String image = this.token.getImage();
                    char ch = image.charAt(image.length() - 1);
                    if (ch == '\'' || ch == '\"') {
                        if (image.charAt(0) == ch && image.length() > 1) {
                            return 0;
                        }
                        boolean closing = false;
                        TokenItem prev = this.token.getPrevious();
                        while (prev != null) {
                            int tid = prev.getTokenID().getNumericID();
                            if (tid == 7) {
                                closing = true;
                                break;
                            }
                            if (tid != 11) break;
                            prev = prev.getPrevious();
                        }
                        if (closing) break;
                        ctx.init(syntaxNode, this.preText);
                        return 2;
                    }
                    ctx.init(syntaxNode, this.preText);
                    return 2;
                }
                NamedNodeMap attrs = syntaxNode.getAttributes();
                int maxOffsetLessThanCurrent = -1;
                AttrImpl curAttrNode = null;
                int ind = 0;
                while (ind < attrs.getLength()) {
                    AttrImpl attr = (AttrImpl)attrs.item(ind);
                    int attrTokOffset = attr.getFirstToken().getOffset();
                    if (attrTokOffset > maxOffsetLessThanCurrent && attrTokOffset < this.token.getOffset()) {
                        maxOffsetLessThanCurrent = attrTokOffset;
                        curAttrNode = attr;
                    }
                    ++ind;
                }
                if (this.preText.length() > 0) {
                    this.preText = this.preText.substring(1);
                }
                if (curAttrNode != null) {
                    ctx.init(curAttrNode, this.preText);
                } else {
                    ctx.init(syntaxNode, this.preText);
                }
                return 2;
            }
            case 6: {
                if (!"".equals(this.preText) || !"=".equals(this.token.getImage())) break;
                ctx.init(syntaxNode, "");
                return 2;
            }
            case 2: {
                if ((class$org$netbeans$modules$xml$text$syntax$dom$StartTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$StartTag = SyntaxQueryHelper.class$("org.netbeans.modules.xml.text.syntax.dom.StartTag")) : class$org$netbeans$modules$xml$text$syntax$dom$StartTag).equals(syntaxNode.getClass()) || (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag = SyntaxQueryHelper.class$("org.netbeans.modules.xml.text.syntax.dom.EmptyTag")) : class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag).equals(syntaxNode.getClass())) {
                    ctx.init((Element)((Object)syntaxNode), "");
                    return 1;
                }
                return 0;
            }
            case 5: {
                if (!(class$org$netbeans$modules$xml$text$syntax$dom$StartTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$StartTag = SyntaxQueryHelper.class$("org.netbeans.modules.xml.text.syntax.dom.StartTag")) : class$org$netbeans$modules$xml$text$syntax$dom$StartTag).equals(syntaxNode.getClass()) && !(class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag == null ? (class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag = SyntaxQueryHelper.class$("org.netbeans.modules.xml.text.syntax.dom.EmptyTag")) : class$org$netbeans$modules$xml$text$syntax$dom$EmptyTag).equals(syntaxNode.getClass())) break;
                ctx.init((Element)((Object)syntaxNode), this.preText);
                return 1;
            }
            case 11: {
                if (this.preText.startsWith("&#")) {
                    return 0;
                }
                if (this.preText.endsWith(";")) {
                    ctx.init(syntaxNode, "");
                    return 2;
                }
                if (this.preText.startsWith("&")) {
                    ctx.init(syntaxNode, this.preText.substring(1));
                    return 4;
                }
                if (!"".equals(this.preText) || !this.token.getImage().endsWith(";")) break;
                ctx.init(syntaxNode, this.preText);
                return 2;
            }
        }
        return 0;
    }

    public HintContext getContext() {
        if (this.completionType != 0 && this.completionType != 6) {
            return ctx;
        }
        return null;
    }

    public TokenItem getToken() {
        return this.token;
    }

    public String getPreText() {
        return this.preText;
    }

    public int getEraseCount() {
        return this.erase;
    }

    public int getOffset() {
        return this.tunedOffset;
    }

    public SyntaxElement getSyntaxElement() {
        return this.element;
    }

    public int getCompletionType() {
        return this.completionType;
    }

    public boolean isBoundary() {
        return this.boundary;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

