/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.text.completion.AttributeResultItem;
import org.netbeans.modules.xml.text.completion.ElementResultItem;
import org.netbeans.modules.xml.text.completion.EntityRefResultItem;
import org.netbeans.modules.xml.text.completion.GrammarManager;
import org.netbeans.modules.xml.text.completion.SyntaxQueryHelper;
import org.netbeans.modules.xml.text.completion.Util;
import org.netbeans.modules.xml.text.completion.ValueResultItem;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.w3c.dom.Node;

public class XMLCompletionQuery
implements CompletionQuery,
XMLTokenIDs {
    public static final String DOCUMENT_GRAMMAR_BINDING_PROP = "doc-bind-query";
    private ThreadLocal thread;
    static /* synthetic */ Class class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport;

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        if (doc == null) {
            return null;
        }
        XMLSyntaxSupport sup = (XMLSyntaxSupport)support.get(class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport == null ? (class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport = XMLCompletionQuery.class$("org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport")) : class$org$netbeans$modules$xml$text$syntax$XMLSyntaxSupport);
        if (sup == null) {
            return null;
        }
        try {
            SyntaxQueryHelper helper = new SyntaxQueryHelper(sup, offset);
            if (helper.getCompletionType() != 6) {
                List list = null;
                switch (helper.getCompletionType()) {
                    case 1: {
                        list = this.queryAttributes(helper, (Document)doc, sup);
                        break;
                    }
                    case 2: {
                        list = this.queryValues(helper, (Document)doc, sup);
                        break;
                    }
                    case 3: {
                        list = this.queryElements(helper, (Document)doc, sup);
                        break;
                    }
                    case 4: {
                        list = this.queryEntities(helper, (Document)doc, sup);
                        break;
                    }
                    case 5: {
                        list = this.queryNotations(helper, (Document)doc, sup);
                    }
                }
                if (list != null && !list.isEmpty()) {
                    String debugMsg = Boolean.getBoolean("netbeans.debug.xml") ? " " + helper.getOffset() + "-" + helper.getEraseCount() : "";
                    String title = Util.THIS.getString("MSG_result", helper.getPreText()) + debugMsg;
                    if (helper.getPreText().endsWith("<") && helper.getToken().getTokenID() == XMLTokenIDs.TEXT) {
                        boolean addEndTag;
                        List startTags = XMLCompletionQuery.findStartTag((SyntaxNode)helper.getSyntaxElement(), "/");
                        boolean bl = addEndTag = !list.isEmpty();
                        if (addEndTag) {
                            EndTag endtag;
                            String nodename;
                            SyntaxElement nextElement;
                            SyntaxNode ctx = (SyntaxNode)helper.getSyntaxElement();
                            SyntaxElement syntaxElement = nextElement = ctx != null ? ctx.getNext() : null;
                            if (nextElement instanceof EndTag && (nodename = (endtag = (EndTag)nextElement).getNodeName()) != null) {
                                ElementResultItem item = (ElementResultItem)startTags.get(0);
                                if (("/" + nodename).equals(item.getItemText())) {
                                    addEndTag = false;
                                }
                            }
                        }
                        if (addEndTag) {
                            list.addAll(startTags);
                        }
                    }
                    return new CompletionQuery.DefaultResult(component, title, list, helper.getOffset() - helper.getEraseCount(), helper.getEraseCount());
                }
                if (helper.getPreText().endsWith("</") && helper.getToken().getTokenID() == XMLTokenIDs.TEXT && (list = XMLCompletionQuery.findStartTag((SyntaxNode)helper.getSyntaxElement())) != null && list.size() == 1) {
                    ElementResultItem item = (ElementResultItem)list.get(0);
                    item.substituteText(component, helper.getOffset(), 0, 0);
                    return null;
                }
                if (list == null) {
                    return XMLCompletionQuery.cannotSuggest(component, sup.requestedAutoCompletion());
                }
                return XMLCompletionQuery.noSuggestion(component, sup.requestedAutoCompletion());
            }
            if (helper.getToken().getTokenID() == XMLTokenIDs.PI_CONTENT && helper.getPreText().endsWith("encoding=")) {
                ArrayList<XMLResultItem> encodings = new ArrayList<XMLResultItem>(2);
                encodings.add(new XMLResultItem("\"UTF-8\""));
                encodings.add(new XMLResultItem("\"UTF-16\""));
                return new CompletionQuery.DefaultResult(component, Util.THIS.getString("MSG_encoding_comp"), encodings, helper.getOffset(), 0);
            }
            return XMLCompletionQuery.noSuggestion(component, sup.requestedAutoCompletion());
        }
        catch (BadLocationException e) {
            Util.THIS.debug(e);
            return XMLCompletionQuery.noSuggestion(component, sup.requestedAutoCompletion());
        }
    }

    private static CompletionQuery.Result cannotSuggest(JTextComponent component, boolean auto) {
        if (auto) {
            return null;
        }
        return new CompletionQuery.DefaultResult(component, Util.THIS.getString("BK0002"), Collections.EMPTY_LIST, 0, 0);
    }

    private static CompletionQuery.Result noSuggestion(JTextComponent component, boolean auto) {
        if (auto) {
            return null;
        }
        return new CompletionQuery.DefaultResult(component, Util.THIS.getString("BK0003"), Collections.EMPTY_LIST, 0, 0);
    }

    public static GrammarQuery getPerformer(Document doc, XMLSyntaxSupport sup) {
        Object grammarBindingObj = doc.getProperty(DOCUMENT_GRAMMAR_BINDING_PROP);
        if (grammarBindingObj == null) {
            grammarBindingObj = new GrammarManager(doc, sup);
            doc.putProperty(DOCUMENT_GRAMMAR_BINDING_PROP, grammarBindingObj);
        }
        return ((GrammarManager)grammarBindingObj).getGrammar();
    }

    private List queryEntities(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryEntities(helper.getContext().getCurrentPrefix());
        return this.translateEntityRefs(res);
    }

    private List queryElements(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryElements(helper.getContext());
        return this.translateElements(res);
    }

    private List queryAttributes(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryAttributes(helper.getContext());
        return this.translateAttributes(res, helper.isBoundary());
    }

    private List queryValues(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryValues(helper.getContext());
        return this.translateValues(res);
    }

    private List queryNotations(SyntaxQueryHelper helper, Document doc, XMLSyntaxSupport sup) {
        Enumeration res = XMLCompletionQuery.getPerformer(doc, sup).queryNotations(helper.getContext().getCurrentPrefix());
        return null;
    }

    private List translateEntityRefs(Enumeration refs) {
        ArrayList<EntityRefResultItem> result = new ArrayList<EntityRefResultItem>(133);
        while (refs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)refs.nextElement();
            EntityRefResultItem ref = new EntityRefResultItem(next);
            result.add(ref);
        }
        return result;
    }

    private List translateElements(Enumeration els) {
        ArrayList<ElementResultItem> result = new ArrayList<ElementResultItem>(13);
        while (els.hasMoreElements()) {
            GrammarResult next = (GrammarResult)els.nextElement();
            ElementResultItem ei = new ElementResultItem(next);
            result.add(ei);
        }
        return result;
    }

    private List translateAttributes(Enumeration attrs, boolean boundary) {
        ArrayList<AttributeResultItem> result = new ArrayList<AttributeResultItem>(13);
        while (attrs.hasMoreElements()) {
            GrammarResult next = (GrammarResult)attrs.nextElement();
            AttributeResultItem attr = new AttributeResultItem(next, !boundary);
            result.add(attr);
        }
        return result;
    }

    private List translateValues(Enumeration values) {
        ArrayList<ValueResultItem> result = new ArrayList<ValueResultItem>(3);
        while (values.hasMoreElements()) {
            GrammarResult next = (GrammarResult)values.nextElement();
            ValueResultItem val = new ValueResultItem(next);
            result.add(val);
        }
        return result;
    }

    private static List findStartTag(SyntaxNode text, String prefix) {
        Node parent;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("XMLCompletionQuery.findStartTag: text=" + text);
        }
        if ((parent = text.getParentNode()) == null) {
            return Collections.EMPTY_LIST;
        }
        String name = parent.getNodeName();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    name=" + name);
        }
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ElementResultItem res = new ElementResultItem(prefix + name);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    result=" + res);
        }
        ArrayList<ElementResultItem> list = new ArrayList<ElementResultItem>(1);
        list.add(res);
        return list;
    }

    private static List findStartTag(SyntaxNode text) {
        return XMLCompletionQuery.findStartTag(text, "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

