/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public abstract class SyntaxElement {
    protected XMLSyntaxSupport support;
    protected TokenItem first;
    private SyntaxElement previous;
    private SyntaxElement next;
    protected int offset;
    protected int length;

    public SyntaxElement(XMLSyntaxSupport support, TokenItem first, int to) {
        this.support = support;
        this.first = first;
        this.offset = first.getOffset();
        this.length = to - this.offset;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public SyntaxElement getPrevious() {
        try {
            if (this.previous == null) {
                if (this.first.getOffset() == 0) {
                    return null;
                }
                this.previous = this.support.getElementChain(this.getElementOffset() - 1);
                if (this.previous != null) {
                    this.previous.next = this;
                    if (this.previous.first.getOffset() == this.first.getOffset()) {
                        throw new IllegalStateException("Previous cannot be the same as current element!");
                    }
                }
            }
            return this.previous;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public SyntaxElement getNext() {
        try {
            if (this.next == null) {
                this.next = this.support.getElementChain(this.offset + this.length + 1);
                if (this.next != null) {
                    this.next.previous = this;
                    if (this.next.first.getOffset() == this.first.getOffset()) {
                        throw new IllegalStateException("Next cannot be the same as current element!");
                    }
                }
            }
            return this.next;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public String toString() {
        return "Node[" + this.offset + "," + (this.offset + this.length - 1) + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object obj) {
        return obj instanceof SyntaxElement && ((SyntaxElement)obj).offset == this.offset;
    }

    public static class Error
    extends SyntaxElement {
        public Error(XMLSyntaxSupport support, TokenItem from, int to) {
            super(support, from, to);
        }

        public String toString() {
            return "Error" + super.toString();
        }
    }
}

