/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax.dom;

import org.netbeans.editor.TokenItem;

public class Util {
    public static String[] knownEntityStrings = new String[]{"&lt;", "&gt;", "&apos;", "&quot;", "&amp;"};
    public static char[] knownEntityChars = new char[]{'<', '>', '\'', '\"', '&'};

    public static TokenItem skipAttributeValue(TokenItem attribute, char delim) {
        TokenItem next = attribute;
        while (next != null) {
            String image = next.getImage();
            if (image.endsWith("" + delim)) {
                return next.getNext();
            }
            next = next.getNext();
        }
        return null;
    }

    public static String actualAttributeValue(String attributeValue) {
        int ltIndex = attributeValue.indexOf(60);
        int gtIndex = attributeValue.indexOf(62);
        int firstUnwantedIndex = -1;
        firstUnwantedIndex = gtIndex != -1 ? (ltIndex != -1 && ltIndex < gtIndex ? ltIndex : gtIndex) : ltIndex;
        if (firstUnwantedIndex != -1) {
            char charAtIndex = attributeValue.charAt(firstUnwantedIndex);
            while (charAtIndex == ' ' || charAtIndex == '\t' || charAtIndex == '\n' || charAtIndex == '\r' || charAtIndex == '<' || charAtIndex == '>') {
                if (--firstUnwantedIndex < 0) break;
                charAtIndex = attributeValue.charAt(firstUnwantedIndex);
            }
            return attributeValue.substring(0, firstUnwantedIndex + 1);
        }
        return attributeValue;
    }

    public static String replaceEntityStringsWithChars(String value) {
        StringBuffer buf = new StringBuffer(value);
        int entity = 0;
        while (entity < knownEntityStrings.length) {
            String curEntityString = knownEntityStrings[entity];
            int indexOfEntity = buf.toString().indexOf(curEntityString);
            while (indexOfEntity != -1) {
                buf.replace(indexOfEntity, indexOfEntity + curEntityString.length(), new String(new char[]{knownEntityChars[entity]}));
                indexOfEntity = buf.toString().indexOf(curEntityString);
            }
            ++entity;
        }
        return buf.toString();
    }

    public static String replaceCharsWithEntityStrings(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer replBuf = new StringBuffer(value.length());
        int ind = 0;
        while (ind < value.length()) {
            boolean charReplaced = false;
            char curChar = value.charAt(ind);
            int entity = 0;
            while (entity < knownEntityChars.length) {
                if (curChar == knownEntityChars[entity]) {
                    replBuf.append(knownEntityStrings[entity]);
                    charReplaced = true;
                    break;
                }
                ++entity;
            }
            if (!charReplaced) {
                replBuf.append(curChar);
            }
            ++ind;
        }
        return replBuf.toString();
    }
}

