/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.html.HtmlDataObject;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableOpenSupport;

public final class HtmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            HtmlEditorSupport.this.saveDocument();
            HtmlEditorSupport.this.getDataObject().setModified(false);
        }
    };
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$modules$html$HtmlEditorSupport;

    HtmlEditorSupport(HtmlDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType("text/html");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        if (obj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = HtmlEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
            obj.getCookieSet0().add((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
    }

    private void removeSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = HtmlEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        byte[] arr;
        int len = stream.read(arr = new byte[4096], 0, arr.length);
        String txt = new String(arr, 0, len >= 0 ? len : 0).toUpperCase();
        txt = HtmlEditorSupport.findEncoding(txt);
        stream = len < arr.length ? new ByteArrayInputStream(arr, 0, len) : new SequenceInputStream(new ByteArrayInputStream(arr), stream);
        if (txt != null) {
            try {
                InputStreamReader r = new InputStreamReader(stream, txt);
                kit.read(r, (Document)doc, 0);
                return;
            }
            catch (UnsupportedEncodingException ex) {
            }
            catch (Exception ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage((Class)(class$org$netbeans$modules$html$HtmlEditorSupport == null ? (class$org$netbeans$modules$html$HtmlEditorSupport = HtmlEditorSupport.class$("org.netbeans.modules.html.HtmlEditorSupport")) : class$org$netbeans$modules$html$HtmlEditorSupport), (String)"MSG_errorInReadingWithEnc", (Object)this.getDataObject().getPrimaryFile().getPath(), (Object)txt));
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        kit.read(stream, (Document)doc, 0);
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        int len = doc.getLength();
        if (len > 4096) {
            len = 4096;
        }
        String txt = doc.getText(0, len).toUpperCase();
        if ((txt = HtmlEditorSupport.findEncoding(txt)) != null) {
            try {
                OutputStreamWriter w = new OutputStreamWriter(stream, txt);
                kit.write(w, (Document)doc, 0, doc.getLength());
                return;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        super.saveFromKitToStream(doc, kit, stream);
    }

    private static String findEncoding(String txt) {
        int content;
        int headLen = txt.indexOf("</HEAD>");
        if (headLen == -1) {
            headLen = txt.length();
        }
        if ((content = txt.indexOf("CONTENT-TYPE")) == -1 || content > headLen) {
            return null;
        }
        int charset = txt.indexOf("CHARSET=", content);
        if (charset == -1) {
            return null;
        }
        int charend = txt.indexOf(34, charset);
        int charend2 = txt.indexOf(39, charset);
        if (charend == -1 && charend2 == -1) {
            return null;
        }
        if (charend2 != -1 && (charend == -1 || charend > charend2)) {
            charend = charend2;
        }
        return txt.substring(charset + "CHARSET=".length(), charend);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;
        static /* synthetic */ Class class$org$netbeans$modules$html$HtmlEditorSupport;

        public Environment(HtmlDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((HtmlDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (HtmlEditorSupport)this.getDataObject().getCookie(class$org$netbeans$modules$html$HtmlEditorSupport == null ? (class$org$netbeans$modules$html$HtmlEditorSupport = Environment.class$("org.netbeans.modules.html.HtmlEditorSupport")) : class$org$netbeans$modules$html$HtmlEditorSupport);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

