/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.usersguide;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyVetoException;
import java.beans.SimpleBeanInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

public class UGModule
extends ModuleInstall {
    private static final long serialVersionUID = -5353846631812949705L;
    private static ErrorManager err = ErrorManager.getDefault();
    private static Object fileSystemOrTrash = null;
    static /* synthetic */ Class class$org$netbeans$modules$usersguide$UGModule;

    private static synchronized FileSystem getFileSystem() {
        if (fileSystemOrTrash instanceof FileSystem) {
            return (FileSystem)fileSystemOrTrash;
        }
        if (fileSystemOrTrash == null) {
            try {
                File dir = UGModule.makeExamplesDir();
                if (dir != null) {
                    fileSystemOrTrash = UGModule.createLocalFS(dir);
                    return (FileSystem)fileSystemOrTrash;
                }
            }
            catch (Exception e) {
                err.notify(16, (Throwable)e);
            }
            fileSystemOrTrash = new Object();
            return null;
        }
        return null;
    }

    public static FileSystem createFileSystem() {
        FileSystem fs = UGModule.getFileSystem();
        if (fs != null) {
            return fs;
        }
        XMLFileSystem bogus = new XMLFileSystem();
        bogus.setHidden(true);
        return bogus;
    }

    public static FileSystem createTimerBeanFS() {
        GlobalJarFileSystem fs;
        File timerBeanJarFile = InstalledFileLocator.getDefault().locate("beans/TimerBean.jar", "org.netbeans.modules.form", false);
        if (timerBeanJarFile == null) {
            return null;
        }
        try {
            GlobalJarFileSystem timerBeanFS = new GlobalJarFileSystem();
            timerBeanFS.setJarFile(timerBeanJarFile);
            FileSystem findFS = Repository.getDefault().findFileSystem(timerBeanFS.getSystemName());
            if (findFS instanceof JarFileSystem) {
                fs = (JarFileSystem)findFS;
            } else {
                fs = timerBeanFS;
                fs.setHidden(true);
            }
        }
        catch (IOException ex) {
            err.notify(16, (Throwable)ex);
            fs = null;
        }
        catch (PropertyVetoException ex) {
            err.notify(16, (Throwable)ex);
            fs = null;
        }
        return fs;
    }

    private static FileSystem createLocalFS(File dir) throws Exception {
        GlobalLocalFileSystem fs = new GlobalLocalFileSystem();
        fs.setRootDirectory(dir);
        return fs;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File makeExamplesDir() throws IOException {
        String homedir = System.getProperty("netbeans.home");
        String userdir = System.getProperty("netbeans.user");
        if (userdir == null) return null;
        if (userdir.equals(homedir)) {
            return null;
        }
        File olddir = new File(userdir, "Development");
        if (olddir.isDirectory()) {
            return olddir;
        }
        String egdir = NbBundle.getMessage((Class)(class$org$netbeans$modules$usersguide$UGModule == null ? (class$org$netbeans$modules$usersguide$UGModule = UGModule.class$("org.netbeans.modules.usersguide.UGModule")) : class$org$netbeans$modules$usersguide$UGModule), (String)"FILE_examples");
        File dir = new File(userdir, egdir);
        if (dir.isDirectory()) return dir;
        err.log(1, "Creating samples directory " + dir);
        if (!dir.mkdirs()) {
            throw new IOException();
        }
        byte[] buf = new byte[4096];
        URL u = new URL("nbresloc:/org/netbeans/modules/usersguide/demosrc.zip");
        ZipInputStream zis = new ZipInputStream(u.openStream());
        try {
            while (true) {
                Object var13_12;
                void var8_8;
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    Object var15_14 = null;
                    break;
                }
                String name = var8_8.getName().replace('/', File.separatorChar);
                if (var8_8.isDirectory()) {
                    if (new File(dir, name).mkdirs()) continue;
                    throw new IOException();
                }
                FileOutputStream os = new FileOutputStream(new File(dir, name));
                try {
                    while (true) {
                        void var11_11;
                        int read;
                        if ((read = zis.read(buf, 0, buf.length)) == -1) {
                            var13_12 = null;
                            break;
                        }
                        ((OutputStream)os).write(buf, 0, (int)var11_11);
                    }
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).close();
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            zis.close();
            throw throwable;
        }
        zis.close();
        return dir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GlobalJarFileSystemBeanInfo
    extends SimpleBeanInfo {
        static /* synthetic */ Class class$org$netbeans$modules$usersguide$UGModule$GlobalJarFileSystem;
        static /* synthetic */ Class class$org$openide$filesystems$JarFileSystem;

        public BeanDescriptor getBeanDescriptor() {
            BeanDescriptor bd = new BeanDescriptor(class$org$netbeans$modules$usersguide$UGModule$GlobalJarFileSystem == null ? (class$org$netbeans$modules$usersguide$UGModule$GlobalJarFileSystem = GlobalJarFileSystemBeanInfo.class$("org.netbeans.modules.usersguide.UGModule$GlobalJarFileSystem")) : class$org$netbeans$modules$usersguide$UGModule$GlobalJarFileSystem);
            bd.setValue("global", Boolean.TRUE);
            bd.setValue("propertiesHelpID", "org.netbeans.modules.usersguide.UGModule.GlobalJarFileSystem.properties");
            bd.setValue("expertHelpID", "org.netbeans.modules.usersguide.UGModule.GlobalJarFileSystem.expert");
            return bd;
        }

        public BeanInfo[] getAdditionalBeanInfo() {
            try {
                return new BeanInfo[]{Introspector.getBeanInfo(class$org$openide$filesystems$JarFileSystem == null ? (class$org$openide$filesystems$JarFileSystem = GlobalJarFileSystemBeanInfo.class$("org.openide.filesystems.JarFileSystem")) : class$org$openide$filesystems$JarFileSystem)};
            }
            catch (IntrospectionException ie) {
                return null;
            }
        }

        public Image getIcon(int kind) {
            try {
                return Introspector.getBeanInfo(class$org$openide$filesystems$JarFileSystem == null ? (class$org$openide$filesystems$JarFileSystem = GlobalJarFileSystemBeanInfo.class$("org.openide.filesystems.JarFileSystem")) : class$org$openide$filesystems$JarFileSystem).getIcon(kind);
            }
            catch (IntrospectionException ie) {
                return null;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class GlobalJarFileSystem
    extends JarFileSystem {
        private static final long serialVersionUID = -2165058869503900139L;
    }

    public static final class GlobalLocalFileSystemBeanInfo
    extends SimpleBeanInfo {
        static /* synthetic */ Class class$org$netbeans$modules$usersguide$UGModule$GlobalLocalFileSystem;
        static /* synthetic */ Class class$org$netbeans$modules$usersguide$UGModule;
        static /* synthetic */ Class class$org$openide$filesystems$LocalFileSystem;

        public BeanDescriptor getBeanDescriptor() {
            BeanDescriptor bd = new BeanDescriptor(class$org$netbeans$modules$usersguide$UGModule$GlobalLocalFileSystem == null ? (class$org$netbeans$modules$usersguide$UGModule$GlobalLocalFileSystem = GlobalLocalFileSystemBeanInfo.class$("org.netbeans.modules.usersguide.UGModule$GlobalLocalFileSystem")) : class$org$netbeans$modules$usersguide$UGModule$GlobalLocalFileSystem);
            bd.setValue("global", Boolean.TRUE);
            bd.setValue("transient", Boolean.TRUE);
            bd.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$usersguide$UGModule == null ? (class$org$netbeans$modules$usersguide$UGModule = GlobalLocalFileSystemBeanInfo.class$("org.netbeans.modules.usersguide.UGModule")) : class$org$netbeans$modules$usersguide$UGModule), (String)"HINT_sampledir"));
            bd.setValue("propertiesHelpID", "org.netbeans.modules.usersguide.UGModule.GlobalLocalFileSystem.properties");
            bd.setValue("expertHelpID", "org.netbeans.modules.usersguide.UGModule.GlobalLocalFileSystem.expert");
            return bd;
        }

        public BeanInfo[] getAdditionalBeanInfo() {
            try {
                return new BeanInfo[]{Introspector.getBeanInfo(class$org$openide$filesystems$LocalFileSystem == null ? (class$org$openide$filesystems$LocalFileSystem = GlobalLocalFileSystemBeanInfo.class$("org.openide.filesystems.LocalFileSystem")) : class$org$openide$filesystems$LocalFileSystem)};
            }
            catch (IntrospectionException ie) {
                err.notify((Throwable)ie);
                return null;
            }
        }

        public Image getIcon(int kind) {
            try {
                return Introspector.getBeanInfo(class$org$openide$filesystems$LocalFileSystem == null ? (class$org$openide$filesystems$LocalFileSystem = GlobalLocalFileSystemBeanInfo.class$("org.openide.filesystems.LocalFileSystem")) : class$org$openide$filesystems$LocalFileSystem).getIcon(kind);
            }
            catch (IntrospectionException ie) {
                err.notify((Throwable)ie);
                return null;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class GlobalLocalFileSystem
    extends LocalFileSystem {
        private static final long serialVersionUID = -2365058849573910139L;
    }
}

