/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.api.model;

import java.beans.FeatureDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.enum.ArrayEnumeration;

public abstract class GrammarQueryManager {
    private static Reference instance;

    public abstract Enumeration enabled(GrammarEnvironment var1);

    public abstract GrammarQuery getGrammar(GrammarEnvironment var1);

    public abstract FeatureDescriptor getDescriptor();

    public static synchronized GrammarQueryManager getDefault() {
        DefaultQueryManager cached;
        DefaultQueryManager defaultQueryManager = cached = instance != null ? (DefaultQueryManager)instance.get() : null;
        if (cached == null) {
            cached = new DefaultQueryManager();
            instance = new WeakReference<DefaultQueryManager>(cached);
        }
        return cached;
    }

    private static class DefaultQueryManager
    extends GrammarQueryManager {
        private static final String FOLDER = "Plugins/XML/GrammarQueryManagers";
        private Lookup.Result registrations;
        private static ThreadLocal transaction = new ThreadLocal();
        static /* synthetic */ Class class$org$netbeans$modules$xml$api$model$GrammarQueryManager;

        private DefaultQueryManager() {
        }

        public FeatureDescriptor getDescriptor() {
            FeatureDescriptor desc = new FeatureDescriptor();
            desc.setHidden(true);
            desc.setName(this.getClass().getName());
            return desc;
        }

        public GrammarQuery getGrammar(GrammarEnvironment ctx) {
            GrammarQuery grammarQuery;
            try {
                GrammarQueryManager g = (GrammarQueryManager)transaction.get();
                if (g != null) {
                    Object err;
                    GrammarQuery query = g.getGrammar(ctx);
                    if (query == null) {
                        err = ErrorManager.getDefault();
                        err.log(16, "Broken contract: " + g.getClass());
                    }
                    err = query;
                    Object var9_7 = null;
                    transaction.set(null);
                    return err;
                }
                ErrorManager err = ErrorManager.getDefault();
                IllegalStateException ex = new IllegalStateException("Broken contract");
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                ex.printStackTrace(writer);
                writer.flush();
                err.log(16, stringWriter.getBuffer().toString());
                grammarQuery = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                transaction.set(null);
                throw throwable;
            }
            Object var9_8 = null;
            transaction.set(null);
            return grammarQuery;
        }

        public Enumeration enabled(GrammarEnvironment ctx) {
            Iterator it = this.getRegistrations();
            transaction.set(null);
            ArrayList list = new ArrayList(5);
            Enumeration enumeration = ctx.getDocumentChildren();
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
            Object[] array = list.toArray();
            while (it.hasNext()) {
                GrammarEnvironment env;
                GrammarQueryManager next = (GrammarQueryManager)it.next();
                Enumeration en = next.enabled(env = new GrammarEnvironment((Enumeration)new ArrayEnumeration(array), ctx.getInputSource(), ctx.getFileObject()));
                if (en == null) continue;
                transaction.set(next);
                return en;
            }
            return null;
        }

        private synchronized Iterator getRegistrations() {
            if (this.registrations != null) {
                return this.registrations.allInstances().iterator();
            }
            try {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                FileObject fo = fs.findResource(FOLDER);
                DataObject df = DataObject.find((FileObject)fo);
                if (df instanceof DataObject.Container) {
                    FolderLookup lookup = new FolderLookup((DataObject.Container)df);
                    Lookup.Template template = new Lookup.Template(class$org$netbeans$modules$xml$api$model$GrammarQueryManager == null ? (class$org$netbeans$modules$xml$api$model$GrammarQueryManager = DefaultQueryManager.class$("org.netbeans.modules.xml.api.model.GrammarQueryManager")) : class$org$netbeans$modules$xml$api$model$GrammarQueryManager);
                    this.registrations = lookup.getLookup().lookup(template);
                    return this.registrations.allInstances().iterator();
                }
                return ((AbstractList)new ArrayList(0)).iterator();
            }
            catch (DataObjectNotFoundException ex) {
                return ((AbstractList)new ArrayList(0)).iterator();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

