/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.modules.xml.core.actions.Util;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class InputOutputReporter
implements CookieObserver {
    private final String FORMAT = "{0} [{1}] {2}";
    private InputOutput xmlIO;
    private OutputWriter ow = null;
    private DataObject dataObject;
    private static final Set hyperlinks = Collections.synchronizedSet(new WeakSet());
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$api$xml$cookies$XMLProcessorDetail;

    public InputOutputReporter() {
        this(Util.THIS.getString("TITLE_XML_check_window"));
    }

    public InputOutputReporter(String name) {
        this.initInputOutput(name);
    }

    public void setNode(Node node) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("InputOutputReporter.setNode: " + node, new RuntimeException("Who calls InputOutputReporter.setNode"));
        }
        this.dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = InputOutputReporter.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
    }

    private DataObject dataObject() {
        return this.dataObject;
    }

    public void receive(CookieMessage msg) {
        Object detail = msg.getDetail(class$org$netbeans$api$xml$cookies$XMLProcessorDetail == null ? (class$org$netbeans$api$xml$cookies$XMLProcessorDetail = InputOutputReporter.class$("org.netbeans.api.xml.cookies.XMLProcessorDetail")) : class$org$netbeans$api$xml$cookies$XMLProcessorDetail);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("InputOutputReporter.receive:");
            Util.THIS.debug("    dataObject = " + this.dataObject);
            Util.THIS.debug("    Message = " + msg);
            Util.THIS.debug("    detail  = " + detail);
            if (detail == null) {
                Util.THIS.debug(new RuntimeException("Message's Detail is _null_!!!"));
            }
        }
        if (detail instanceof XMLProcessorDetail) {
            this.display(this.dataObject(), msg.getMessage(), (XMLProcessorDetail)detail);
        } else {
            this.message(msg.getMessage());
        }
    }

    public void message(String message) {
        this.ow.println(message);
    }

    public final void moveToFront() {
        boolean wasFocusTaken = this.xmlIO.isFocusTaken();
        this.xmlIO.select();
        this.xmlIO.setFocusTaken(true);
        this.ow.write("\r");
        this.xmlIO.setFocusTaken(wasFocusTaken);
    }

    private void display(DataObject dobj, String message, XMLProcessorDetail detail) {
        DataObject actualDataObject;
        block10: {
            actualDataObject = null;
            try {
                URL url;
                File file;
                FileObject[] fos;
                String systemId = detail.getSystemId();
                if (systemId != null && systemId.startsWith("file:") && (fos = FileUtil.fromFile((File)(file = new File(systemId.substring(5))))).length > 0) {
                    try {
                        systemId = fos[0].getURL().toExternalForm();
                    }
                    catch (FileStateInvalidException exc) {
                        // empty catch block
                    }
                }
                if ((fos = URLMapper.findFileObjects((URL)(url = new URL(systemId)))).length > 0) {
                    actualDataObject = DataObject.find((FileObject)fos[0]);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("InputOutputReporter.display: " + message);
                    Util.THIS.debug("    systemId = " + detail.getSystemId());
                    Util.THIS.debug("    url = " + url);
                    Util.THIS.debug("    fos = " + Arrays.asList(fos));
                }
            }
            catch (MalformedURLException ex) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug(ex);
                }
            }
            catch (DataObjectNotFoundException ex) {
                if (!Util.THIS.isLoggable()) break block10;
                Util.THIS.debug(ex);
            }
        }
        String external = "";
        if (actualDataObject == null) {
            actualDataObject = dobj;
            external = detail.getSystemId();
        }
        this.display(actualDataObject, message, external, detail.getLineNumber(), detail.getColumnNumber());
    }

    private void display(DataObject dobj, String message, String ext, int line, int col) {
        String text = null;
        if (line >= 0) {
            Object[] args = new Object[]{message, new Integer(line), ext};
            text = MessageFormat.format("{0} [{1}] {2}", args);
        } else {
            text = message;
        }
        try {
            if (dobj == null) {
                throw new IOException("catchIt");
            }
            Hyperlink ec = new Hyperlink(text, dobj, Math.max(line - 1, 0), Math.max(col - 1, 0));
            this.ow.println(text, (OutputListener)ec);
        }
        catch (IOException catchIt) {
            this.ow.println(text);
        }
    }

    private void initInputOutput(String name) {
        if (this.ow != null) {
            return;
        }
        this.xmlIO = IOProvider.getDefault().getIO(name, false);
        this.xmlIO.setFocusTaken(false);
        this.ow = this.xmlIO.getOut();
        try {
            this.ow.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void releaseAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((Hyperlink)it.next()).detach();
            }
            hyperlinks.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private Line xline;
        private int column;
        private final String message;
        static /* synthetic */ Class class$org$openide$cookies$LineCookie;

        public Hyperlink(String message, DataObject data, int line, int column) throws IOException {
            this.column = column;
            this.message = message;
            LineCookie cookie = (LineCookie)data.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = Hyperlink.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (cookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = cookie.getLineSet().getCurrent(line);
        }

        public void outputLineSelected(OutputEvent ev) {
            try {
                this.markError();
                this.show(0);
            }
            catch (IndexOutOfBoundsException ex) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineAction(OutputEvent ev) {
            try {
                this.markError();
                this.show(2);
            }
            catch (IndexOutOfBoundsException ex) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            hyperlinks.remove(this);
            this.detach();
        }

        protected void notifyDetached(Annotatable ann) {
            ann.removePropertyChangeListener((PropertyChangeListener)this);
        }

        protected void notifyAttached(Annotatable ann) {
            ann.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private Annotatable createAnnotatable() {
            return this.xline;
        }

        private void show(int mode) {
            if (this.column == -1) {
                this.xline.show(mode);
            } else {
                this.xline.show(mode, this.column);
            }
        }

        private void markError() {
            InputOutputReporter.releaseAllAnnotations();
            hyperlinks.add(this);
            this.attach(this.createAnnotatable());
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-xml-core-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("text") || prop.equals("deleted")) {
                this.column = -1;
                hyperlinks.remove(this);
                this.detach();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

