/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.cookies;

import java.awt.Dialog;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.xml.api.cookies.ScenarioCookie;
import org.netbeans.modules.xml.api.scenario.Scenario;
import org.netbeans.modules.xml.core.cookies.ScenarioData;
import org.netbeans.modules.xml.core.cookies.Util;
import org.netbeans.modules.xml.core.scenario.ScenarioPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

public class ScenarioSupport
implements ScenarioCookie {
    public static final String SCENARIO_DATA_ATTRIBUTE = "org.netbeans.modules.xml.core.cookies.ScenarioData";
    private DataObject dataObject;
    private DefaultComboBoxModel scenarioModel;
    private ScenarioData data;
    static /* synthetic */ Class class$org$netbeans$modules$xml$core$cookies$ScenarioSupport;

    public ScenarioSupport(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public boolean customizeScenarios() {
        DefaultComboBoxModel model = this.getModel();
        ScenarioPanel scenarioPanel = new ScenarioPanel(this.dataObject, model);
        DialogDescriptor scenariosDD = new DialogDescriptor((Object)scenarioPanel, Util.THIS.getString("NAME_customize_scenarios_title"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(class$org$netbeans$modules$xml$core$cookies$ScenarioSupport == null ? (class$org$netbeans$modules$xml$core$cookies$ScenarioSupport = ScenarioSupport.class$("org.netbeans.modules.xml.core.cookies.ScenarioSupport")) : class$org$netbeans$modules$xml$core$cookies$ScenarioSupport), null);
        scenariosDD.setClosingOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(scenariosDD);
        if (model.getSize() == 0 && !scenarioPanel.createScenario()) {
            return false;
        }
        dialog.show();
        if (scenariosDD.getValue() == NotifyDescriptor.OK_OPTION) {
            int ind = 0;
            while (ind < model.getSize()) {
                Scenario scenario = (Scenario)model.getElementAt(ind);
                scenario.saveChanges();
                ++ind;
            }
            this.saveData();
            return true;
        }
        scenarioPanel.rollBackAddedAndRemovedScenarios();
        return false;
    }

    public DefaultComboBoxModel getModel() {
        if (this.scenarioModel == null) {
            this.scenarioModel = new DefaultComboBoxModel(this.getData().getScenarios()){

                public void setSelectedItem(Object anItem) {
                    super.setSelectedItem(anItem);
                    ScenarioSupport.this.saveData();
                }
            };
            this.scenarioModel.setSelectedItem(this.scenarioModel.getElementAt(this.getData().getActiveScenarioIndex()));
            this.scenarioModel.addListDataListener(new ListDataListener(){

                public void contentsChanged(ListDataEvent e) {
                    ScenarioSupport.this.saveData();
                }

                public void intervalAdded(ListDataEvent e) {
                    ScenarioSupport.this.saveData();
                }

                public void intervalRemoved(ListDataEvent e) {
                    ScenarioSupport.this.saveData();
                }
            });
        }
        return this.scenarioModel;
    }

    public void executeActiveScenario() {
        DefaultComboBoxModel model = this.getModel();
        Scenario activeScenario = (Scenario)model.getSelectedItem();
        if (activeScenario == null && this.customizeScenarios()) {
            activeScenario = (Scenario)model.getSelectedItem();
        }
        if (activeScenario != null) {
            activeScenario.execute(this.dataObject);
        }
    }

    private void saveData() {
        if (this.scenarioModel == null || this.data == null) {
            return;
        }
        try {
            this.data.setActiveScenarioIndex(this.scenarioModel.getIndexOf(this.scenarioModel.getSelectedItem()));
            FileObject fileObject = this.dataObject.getPrimaryFile();
            if (fileObject != null) {
                fileObject.setAttribute(SCENARIO_DATA_ATTRIBUTE, (Object)this.data);
            }
        }
        catch (IOException e) {
            String message = Util.THIS.getString("MSG_Problems_saving_scenarios_persistently") + "\n" + e.getMessage();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private ScenarioData getData() {
        if (this.data == null) {
            Object objData;
            FileObject fileObject = this.dataObject.getPrimaryFile();
            if (fileObject != null && (objData = fileObject.getAttribute(SCENARIO_DATA_ATTRIBUTE)) instanceof ScenarioData) {
                this.data = (ScenarioData)fileObject.getAttribute(SCENARIO_DATA_ATTRIBUTE);
            }
            if (this.data == null) {
                this.data = new ScenarioData();
            }
        }
        return this.data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

