/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.lib;

import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public abstract class AbstractUtil {
    private String packageName;
    private ErrorManager packageErrorManager;
    private static final int DEBUG_SEVERITY = 1;

    private final synchronized String getPackageName() {
        if (this.packageName == null) {
            this.packageName = this.getClass().getPackage().getName().intern();
        }
        return this.packageName;
    }

    public final String getString(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public final String getString(String key, Object param) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)param);
    }

    public final String getString(String key, Object param1, Object param2) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)param1, (Object)param2);
    }

    public final char getChar(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key).charAt(0);
    }

    public final boolean isLoggable() {
        return this.getErrorManager().isLoggable(1);
    }

    public final void debug(String message) {
        if (message == null) {
            return;
        }
        this.getErrorManager().log(1, message);
    }

    public final void debug(Throwable ex) {
        if (ex == null) {
            return;
        }
        this.getErrorManager().notify(1, ex);
    }

    public final void debug(String message, Throwable ex) {
        if (ex == null) {
            return;
        }
        if (message != null) {
            ex = this.getErrorManager().annotate(ex, 1, message, null, null, null);
        }
        this.debug(ex);
    }

    public final synchronized ErrorManager getErrorManager() {
        if (this.packageErrorManager == null) {
            String pack = this.getPackageName();
            this.packageErrorManager = ErrorManager.getDefault().getInstance(pack);
        }
        return this.packageErrorManager;
    }
}

