/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.text;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.netbeans.modules.xml.core.text.TextEditorSupport;
import org.netbeans.modules.xml.core.text.Util;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TextEditorComponent
extends CloneableEditor {
    private static final long serialVersionUID = 5983822115073046891L;
    private TextEditorSupport support;
    private CaretListener caretListener;

    public TextEditorComponent() {
    }

    public TextEditorComponent(TextEditorSupport editor) {
        super((CloneableEditorSupport)editor);
        this.initialize();
        this.dockIntoEditorMode();
    }

    protected void updateName() {
        super.updateName();
    }

    private void initialize() {
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
        this.support = (TextEditorSupport)this.cloneableEditorSupport();
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                TextEditorComponent.this.support.restartTimer(true);
            }
        };
        if (this.pane != null) {
            this.pane.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    TextEditorComponent.this.support.syncDocument(true);
                }
            });
        }
    }

    private void dockIntoEditorMode() {
        Workspace current = WindowManager.getDefault().getCurrentWorkspace();
        Mode editorMode = current.findMode("editor");
        if (editorMode != null) {
            editorMode.dockInto((TopComponent)this);
        }
    }

    protected void componentActivated() {
        this.pane.addCaretListener(this.caretListener);
        super.componentActivated();
    }

    protected void componentDeactivated() {
        this.pane.removeCaretListener(this.caretListener);
        super.componentDeactivated();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TextEditorComponent.readExternal()");
        }
        super.readExternal(in);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                   .readExternal(): support = " + this.cloneableEditorSupport());
        }
        this.initialize();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\tdone.");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TextEditorComponent.writeExternal(): support = " + this.cloneableEditorSupport());
        }
        super.writeExternal(out);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\tdone.");
        }
    }
}

