/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.Component;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.core.wizard.DocumentModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public abstract class AbstractPanel
extends JPanel
implements Customizer {
    private static final long serialVersionUID = 508989667995691L;
    protected DocumentModel model;
    private WizardStep step;

    protected abstract void updateModel();

    protected abstract void initView();

    protected abstract void updateView();

    public void setObject(Object model) {
        if (AbstractPanel.not(model instanceof DocumentModel)) {
            throw new IllegalArgumentException("DocumentModel class expected.");
        }
        this.model = (DocumentModel)model;
        this.initView();
    }

    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }

    protected static boolean not(boolean expr) {
        return !expr;
    }

    protected final WizardStep getStep() {
        if (this.step == null) {
            throw new IllegalStateException("new WizardStep(this) have not been called!");
        }
        return this.step;
    }

    public static class WizardStep
    implements WizardDescriptor.Panel {
        private final AbstractPanel peer;
        private Vector listeners = new Vector();
        private final ChangeEvent EVENT = new ChangeEvent(this);
        private boolean valid = true;

        public WizardStep(AbstractPanel peer) {
            if (peer == null) {
                throw new NullPointerException();
            }
            this.peer = peer;
            peer.step = this;
        }

        public Component getComponent() {
            return this.peer;
        }

        public void readSettings(Object settings) {
            this.peer.updateView();
        }

        public final HelpCtx getHelp() {
            return new HelpCtx(this.peer.getClass());
        }

        public void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public void storeSettings(Object settings) {
            this.peer.updateModel();
        }

        public boolean isValid() {
            return this.valid;
        }

        protected final void setValid(boolean valid) {
            if (this.valid == valid) {
                return;
            }
            this.valid = valid;
            Vector vector = this.listeners;
            synchronized (vector) {
                Iterator it = ((AbstractList)this.listeners).iterator();
                while (it.hasNext()) {
                    ChangeListener next = (ChangeListener)it.next();
                    next.stateChanged(this.EVENT);
                }
            }
        }

        public void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }
    }
}

